package cn.sylinx.horm.resource.io;

import cn.sylinx.horm.config.OrmConfig;

public class SqlResourceScanner extends BaseResourceScanner {

	private String matchedPostfix = OrmConfig.DEFAULT_SQL_POST_FIX;

	public SqlResourceScanner(String packageName) {
		this(packageName, OrmConfig.DEFAULT_SQL_POST_FIX);
	}

	public SqlResourceScanner(String packageName, String matchedPostfix) {
		super(packageName);
		this.matchedPostfix = matchedPostfix;
	}

	@Override
	protected String getMatchedPostfix() {
		return matchedPostfix;
	}

	public void setMatchedPostfix(String matchedPostfix) {
		this.matchedPostfix = matchedPostfix;
	}

	@Override
	protected Object transform(String resoureName) {
		return resoureName.replace('.', '/') + getMatchedPostfix();
	}
}
