package cn.sylinx.horm.starter;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.config.SingleDataSourceConfig;
import cn.sylinx.horm.config.specific.SpecificConfig;
import cn.sylinx.horm.config.specific.SpecificConfigHolder;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.datasource.NamedDataSource;

/**
 * 
 * <pre>
 * 如果SqlClient初始化过，则使用初始化中的各配置；
 * 如果没有，则使用默认配置，并且Command、Mapper无法使用。
 * </pre>
 * 
 * @author johnhan
 *
 */
public final class CustomizedSqlClientRegUtil {

	/**
	 * 创建数据源
	 * 
	 * @param singleDataSourceConfig
	 * @return
	 */
	public static NamedDataSource build(SingleDataSourceConfig singleDataSourceConfig) {
		return Utils.build(singleDataSourceConfig);
	}

	/**
	 * 使用指定数据源启动SqlClient
	 * 
	 * @param singleDataSourceConfig
	 * @return
	 */
	public static SqlClient register(SingleDataSourceConfig singleDataSourceConfig) {
		return register(build(singleDataSourceConfig), false);
	}

	/**
	 * 使用指定数据源启动SqlClient
	 * 
	 * @param namedDataSource
	 * @return
	 */
	public static SqlClient register(NamedDataSource namedDataSource) {
		return register(namedDataSource, false);
	}

	/**
	 * 使用指定数据源启动SqlClient
	 * 
	 * @param namedDataSource
	 * @param isParseSqlPathDbtype
	 */
	public static SqlClient register(NamedDataSource namedDataSource, boolean isParseSqlPathDbtype) {
		return register(namedDataSource, isParseSqlPathDbtype, null);
	}

	/**
	 * 使用指定数据源启动SqlClient
	 * 
	 * @param namedDataSource
	 * @param isParseSqlPathDbtype
	 * @param specificConfig
	 * @return
	 */
	public static SqlClient register(NamedDataSource namedDataSource, boolean isParseSqlPathDbtype,
			SpecificConfig specificConfig) {
		SqlClientInitializor sqlClientInitializor = new DefaultSqlClientInitializor();
		OrmConfig cfg = new OrmConfig();
		cfg.setParseSqlPathDbtype(isParseSqlPathDbtype);
		if (specificConfig != null) {
			SpecificConfigHolder.addSpecificConfig(cfg, namedDataSource.getDataSourceName(), specificConfig);
		}
		return sqlClientInitializor.initSqlClient(namedDataSource, cfg);
	}
}
