
package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.sylinx.horm.type.JdbcType;

public class NStringTypeHandler extends BaseTypeHandler<String> {

	@Override
	protected JdbcType getJdbcTypeMapper() {
		return JdbcType.NVARCHAR;
	}

	@Override
	public void setNonNullParameter(PreparedStatement ps, int i, String parameter)
			throws SQLException {
		ps.setNString(i, parameter);
	}

	@Override
	public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
		return rs.getNString(columnName);
	}

	@Override
	public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
		return rs.getNString(columnIndex);
	}

	@Override
	public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
		return cs.getNString(columnIndex);
	}

}
