package cn.sylinx.horm.util;

import java.util.concurrent.Callable;

import cn.sylinx.horm.exception.HORMException;

public abstract class ExceptionCatcher {

	public static void run(Runnable runnable) {
		try {
			runnable.run();
		} catch (Exception e) {
			throw new HORMException(e);
		}
	}

	public static <T extends Object> T call(Callable<T> callable) {
		try {
			return callable.call();
		} catch (Exception e) {
			throw new HORMException(e);
		}
	}
}