/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core.common;

import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.type.handler.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OrmUtil {
    public static void setParameter(Dialect dialect, PreparedStatement pst, int index, Object param) throws SQLException {
        TypeHandler<Object> handler = null;
        Object actuallyParameter = null;
        if (param == null) {
            handler = dialect.getUnknownTypeHandler();
        } else if (param instanceof TypedParameter) {
            TypedParameter typedParam = (TypedParameter)param;
            handler = OrmUtil.getTypeHandler(dialect, typedParam.getParameterType());
            actuallyParameter = typedParam.getParameter();
        } else {
            handler = OrmUtil.getTypeHandler(dialect, param.getClass());
            actuallyParameter = param;
        }
        if (handler != null) {
            handler.setParameter(pst, index, actuallyParameter);
        } else {
            pst.setObject(index, actuallyParameter);
        }
    }

    public static <T> T getResult(Dialect dialect, ResultSet rs, String columnName, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = OrmUtil.getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(rs, columnName);
        }
        return (T)rs.getObject(columnName);
    }

    public static <T> T getResult(Dialect dialect, ResultSet rs, int columnIndex, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = OrmUtil.getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(rs, columnIndex);
        }
        return (T)rs.getObject(columnIndex);
    }

    public static <T> T getResult(Dialect dialect, CallableStatement cs, int columnIndex, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = OrmUtil.getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(cs, columnIndex);
        }
        return (T)cs.getObject(columnIndex);
    }

    private static <T> TypeHandler<T> getTypeHandler(Dialect dialect, Class<T> clz) {
        if (dialect == null) {
            throw new HORMException("dialect is null");
        }
        return dialect.crateTypeHandler(clz);
    }
}

