/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.model.cache.ModelCacheUtil;

class OracleFS<T>
extends FS<T> {
    OracleFS() {
    }

    public static <T> FS<T> of(Class<T> modelClass) {
        return new OracleFS<T>().init(modelClass);
    }

    public static <T> FS<T> of(Class<T> modelClass, String tablePostfix) {
        return new OracleFS<T>().init(modelClass, tablePostfix);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass) {
        return new OracleFS<T>().init(tablePrefix, modelClass);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return new OracleFS<T>().init(tablePrefix, modelClass, tablePostfix);
    }

    @Override
    protected String getDefaultTableName() {
        return this.preEscape + this.tablePrefix + ModelCacheUtil.getModelFabric(this.modelClass).getTableName().toUpperCase() + this.tablePostfix + this.postEscape;
    }

    @Override
    protected String[] getEscape() {
        return new String[]{"\"", "\""};
    }

    @Override
    protected String mapColumn(String column) {
        String trueColumn = (String)this.attrs.get(column);
        return this.preEscape + (trueColumn == null ? column : trueColumn).toUpperCase() + this.postEscape;
    }
}

