/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.dialect.fs.FluentSqlParams;
import cn.sylinx.horm.dialect.sql.DefaultSqlBuilder;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.anno.PrimaryKey;
import cn.sylinx.horm.model.base.Model;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.model.optlock.OptimisticLockInsert;
import cn.sylinx.horm.model.optlock.OptimisticLockUpdate;
import cn.sylinx.horm.model.optlock.OptimisticLockWrapper;
import cn.sylinx.horm.model.util.ModelByDialectUtil;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OracleSqlBuilder
extends DefaultSqlBuilder {
    private String escape0 = "\"";
    private String escape1 = "\"";

    OracleSqlBuilder() {
    }

    @Override
    protected String[] getEscapeChar() {
        return new String[]{"\"", "\""};
    }

    @Override
    public <T> Pair buildDeleteSQL(T t) {
        if (t == null) {
            throw new HORMException("model is null");
        }
        ModelFabric modelFabric = ModelCacheUtil.getModelFabric(t.getClass());
        String tableName = modelFabric.getTableName();
        PrimaryKey pk = modelFabric.getPrimaryKey();
        List<String> pks = this.getPrimaryKey(pk);
        Map<String, String> map = modelFabric.getAttrMapping();
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null || pks.isEmpty()) {
            GLog.error("primary key is empty~", new Object[0]);
            return null;
        }
        if (map == null || map.isEmpty()) {
            GLog.error("java to jdbc mapper is empty~", new Object[0]);
            return null;
        }
        String token = " AND ";
        List<Field> fields = ModelCacheUtil.getObjectAllFieldsWithcache(t.getClass());
        StringBuilder sql = new StringBuilder("DELETE FROM " + this.escape0 + tableName.toUpperCase() + this.escape1 + " WHERE ");
        boolean find = false;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            for (Field item : fields) {
                String fieldName = item.getName();
                if (!pks.contains(fieldName)) continue;
                String f = map.get(fieldName);
                item.setAccessible(true);
                Object v = item.get(t);
                if (f == null || v == null) continue;
                find = true;
                sql.append(this.escape0).append(f.toUpperCase()).append(this.escape1).append(" = ? ").append(" AND ");
                params.add(v);
            }
        }
        catch (IllegalAccessException e) {
            throw new HORMException(e);
        }
        if (!find) {
            return null;
        }
        int totalLen = sql.length();
        int index = sql.length() - " AND ".length();
        sql.delete(index, totalLen);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sqlNative = sql.toString();
        GLog.debug("sql:{} , params:{}", sqlNative, objects);
        return Pair.apply((Object)sqlNative, (Object)objects);
    }

    @Override
    public <T> Pair buildInsertSQL(T t) {
        if (t == null) {
            throw new HORMException("model is null");
        }
        ModelFabric mf = ModelCacheUtil.getModelFabric(t.getClass());
        Map<String, String> map = mf.getAttrMapping();
        String tableName = mf.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("insert mapper is empty~", new Object[0]);
            throw new HORMException("insert mapper is empty~");
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            throw new HORMException("table name is empty~");
        }
        List<Field> fields = ModelCacheUtil.getObjectAllFieldsWithcache(t.getClass());
        if (fields.isEmpty()) {
            GLog.error("no fields", new Object[0]);
            throw new HORMException("no fields");
        }
        StringBuilder fds = new StringBuilder();
        StringBuilder fdsv = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        fds.append("(");
        fdsv.append("(");
        OptimisticLockInsert optimisticLockInsert = OptimisticLockWrapper.parseOptimisticLockInsert(t);
        try {
            if (optimisticLockInsert != null) {
                optimisticLockInsert.getVersionField().set(t, optimisticLockInsert.getInitVersionValue());
            }
            for (Field item : fields) {
                String fieldName = item.getName();
                if (!map.containsKey(fieldName)) continue;
                item.setAccessible(true);
                Object v = item.get(t);
                if (v == null || "".equals(v.toString().trim())) continue;
                String jdbcFieldName = map.get(fieldName);
                fds.append(this.escape0).append(jdbcFieldName.toUpperCase()).append(this.escape1).append(",");
                fdsv.append("?,");
                params.add(v);
            }
        }
        catch (IllegalAccessException e) {
            throw new HORMException(e);
        }
        if (fds.length() <= 1) {
            return null;
        }
        fds.deleteCharAt(fds.length() - 1);
        fdsv.deleteCharAt(fdsv.length() - 1);
        fds.append(")");
        fdsv.append(")");
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.escape0).append(tableName.toUpperCase()).append(this.escape1).append((CharSequence)fds).append(" VALUES ").append((CharSequence)fdsv);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i) instanceof Date) {
                Date d = (Date)params.get(i);
                objects[i] = new Date(d.getTime());
                continue;
            }
            objects[i] = params.get(i);
        }
        String sql = sb.toString();
        GLog.debug("sql:{} , params:{}", sql, objects);
        return Pair.apply((Object)sql, (Object)objects);
    }

    @Override
    public <T> Pair buildUpdateSQL(T t) {
        List<Field> fields;
        if (t == null) {
            throw new HORMException("model is null");
        }
        ModelFabric mf = ModelCacheUtil.getModelFabric(t.getClass());
        Map<String, String> map = mf.getAttrMapping();
        List<String> pks = this.getPrimaryKey(mf.getPrimaryKey());
        String tableName = mf.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("update mapper is empty~", new Object[0]);
            throw new HORMException("update mapper is empty");
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            throw new HORMException("table name is empty");
        }
        if (pks == null) {
            pks = Collections.emptyList();
        }
        if ((fields = ModelCacheUtil.getObjectAllFieldsWithcache(t.getClass())).isEmpty()) {
            throw new HORMException("fields is empty~");
        }
        HashMap<String, Object> pkKv = new HashMap<String, Object>();
        StringBuilder fds = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        Set<Object> nullableSets = new HashSet();
        if (t instanceof Model) {
            nullableSets = ((Model)t).getNullableFields();
        }
        OptimisticLockUpdate olu = OptimisticLockWrapper.parseOptimisticLockUpdate(t);
        try {
            if (olu != null) {
                olu.getVersionField().set(t, olu.getNewVersionValue());
            }
            for (Field item : fields) {
                item.setAccessible(true);
                Iterator fieldName = item.getName();
                if (pks.contains(fieldName)) {
                    Object pkValue = item.get(t);
                    String columnKey = map.get(fieldName);
                    pkKv.put(columnKey, pkValue);
                    continue;
                }
                String f = map.get(fieldName);
                Object v = item.get(t);
                if (f == null) continue;
                boolean nullable = nullableSets.contains(fieldName);
                if (v != null) {
                    fds.append(this.escape0).append(f.toUpperCase()).append(this.escape1).append(" = ?,");
                    params.add(v);
                    continue;
                }
                if (!nullable) continue;
                fds.append(this.escape0).append(f.toUpperCase()).append(this.escape1).append(" = NULL,");
            }
        }
        catch (IllegalAccessException e) {
            throw new HORMException(e);
        }
        if (fds.length() <= 0) {
            throw new RuntimeException("update values is empty ~");
        }
        fds.deleteCharAt(fds.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(this.escape0).append(tableName.toUpperCase()).append(this.escape1).append(" SET ").append((CharSequence)fds);
        if (!pkKv.isEmpty()) {
            String token = " AND ";
            sb.append(" WHERE ");
            if (pks.size() == pkKv.size()) {
                for (String k : pks) {
                    String c = map.get(k);
                    sb.append(this.escape0).append(c.toUpperCase()).append(this.escape1).append(" = ?").append(" AND ");
                    params.add(pkKv.get(c));
                }
            } else {
                for (Map.Entry entry : pkKv.entrySet()) {
                    sb.append(this.escape0).append(((String)entry.getKey()).toUpperCase()).append(this.escape1).append(" = ?").append(" AND ");
                    params.add(entry.getValue());
                }
            }
            if (olu != null) {
                String columnKey = map.get(olu.getVersionFieldAttr());
                sb.append(this.escape0).append(columnKey).append(this.escape1).append(" = ?").append(" AND ");
                params.add(olu.getOldVersionValue());
            }
            int totalLen = sb.length();
            int index = sb.length() - " AND ".length();
            sb.delete(index, totalLen);
        }
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sql = sb.toString();
        GLog.debug("sql:{} , params:{}", sql, objects);
        return Pair.apply((Object)sql, (Object)objects);
    }

    @Override
    public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {
        String sqlCount = "SELECT count(1) as totalCount from (" + preSql + ")";
        int offsetBegin = pageSize * (pageNumber - 1);
        int offsetEnd = offsetBegin + pageSize;
        String sqlLimit = "SELECT /*+ FIRST_ROWS */ * FROM (SELECT A.*, ROWNUM RN FROM (" + preSql + ") A  WHERE ROWNUM <= ?) WHERE RN > ? ";
        Object[] params = new Object[]{offsetEnd, offsetBegin};
        return Tuple.apply(sqlCount, sqlLimit, params);
    }

    @Override
    public Pair buildDeleteByFieldSQL(List<Pair> kvList, Class<?> clz) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        String table = mf.getTableName();
        if (table == null) {
            throw new HORMException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        Map<String, String> am = mf.getAttrMapping();
        if (am == null) {
            throw new HORMException("\u5bf9\u8c61\u6620\u5c04\u5b57\u6bb5\u7f3a\u5931");
        }
        String andToken = " and ";
        StringBuilder sb = new StringBuilder();
        ArrayList paramList = new ArrayList();
        for (int i = 0; i < kvList.size(); ++i) {
            Pair kv = kvList.get(i);
            String field = (String)kv.getKey();
            Object value = kv.getValue();
            String trueField = am.get(field);
            if (trueField == null) {
                trueField = field;
            }
            if (value == null) {
                sb.append(this.escape0).append(trueField.toUpperCase()).append(this.escape1).append(" IS NULL").append(andToken);
                continue;
            }
            sb.append(this.escape0).append(trueField.toUpperCase()).append(this.escape1).append(" = ?").append(andToken);
            paramList.add(value);
        }
        sb.delete(sb.length() - andToken.length(), sb.length());
        String sql = "DELETE FROM " + this.escape0 + table.toUpperCase() + this.escape1 + " WHERE " + sb.toString();
        return Pair.apply((Object)sql, (Object)paramList.toArray());
    }

    @Override
    public Pair buildQueryByFieldSQL(List<Pair> kvList, Class<?> clz) {
        return this.buildQueryByFieldSQL(kvList, clz, null);
    }

    @Override
    public Pair buildQueryByFieldSQL(List<Pair> kvList, Class<?> clz, String[] fields) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        String table = mf.getTableName();
        if (table == null) {
            throw new HORMException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        Map<String, String> am = mf.getAttrMapping();
        if (am == null) {
            throw new HORMException("\u5bf9\u8c61\u6620\u5c04\u5b57\u6bb5\u7f3a\u5931");
        }
        String andToken = " AND ";
        StringBuilder sb = new StringBuilder();
        ArrayList paramList = new ArrayList();
        for (int i = 0; i < kvList.size(); ++i) {
            String[] kv = kvList.get(i);
            String field = (String)kv.getKey();
            Object value = kv.getValue();
            String trueField = am.get(field);
            if (trueField == null) {
                trueField = field;
            }
            if (value == null) {
                sb.append(this.escape0).append(trueField.toUpperCase()).append(this.escape1).append(" IS NULL").append(andToken);
                continue;
            }
            sb.append(this.escape0).append(trueField.toUpperCase()).append(this.escape1).append(" = ?").append(andToken);
            paramList.add(value);
        }
        sb.delete(sb.length() - andToken.length(), sb.length());
        StringBuilder sf = new StringBuilder();
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                String trueField = am.get(field);
                if (trueField == null) {
                    trueField = field;
                }
                sf.append(this.escape0).append(trueField.toUpperCase()).append(this.escape1).append(",");
            }
            sf.deleteCharAt(sf.length() - 1);
        } else {
            sf.append("*");
        }
        String sql = "SELECT " + sf.toString() + " FROM " + this.escape0 + table.toUpperCase() + this.escape1 + " WHERE " + sb.toString();
        return Pair.apply((Object)sql, (Object)paramList.toArray());
    }

    @Override
    public String buildSimpleQuery(Class<?> clz) {
        return this.buildSimpleQuery(clz, null);
    }

    @Override
    public String buildSimpleQuery(Class<?> clz, String[] fields) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        String table = mf.getTableName();
        if (table == null) {
            throw new RuntimeException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        Map<String, String> am = mf.getAttrMapping();
        if (fields == null || fields.length == 0 || am == null) {
            return "SELECT * FROM " + this.escape0 + table.toUpperCase() + this.escape1;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        for (String field : fields) {
            String trueField = am.get(field);
            if (trueField == null) {
                trueField = field;
            }
            sb.append(this.escape0).append(trueField.toUpperCase()).append(this.escape1).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" FROM ").append(this.escape0).append(table.toUpperCase()).append(this.escape1);
        return sb.toString();
    }

    @Override
    public String buildValidateQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String getTable(Class<?> clz) {
        String table = ModelCacheUtil.getModelFabric(clz).getTableName();
        return table.toUpperCase();
    }

    @Override
    public String getTableColumn(Class<?> clz, String prop) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrMap = mf.getAttrMapping();
        String column = attrMap.get(prop);
        if (column == null) {
            column = prop;
        }
        return column.toUpperCase();
    }

    @Override
    public Tuple buildSelectSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(sqlParams.getHint())) {
            sql.append(sqlParams.getHint()).append(" ");
        }
        sql.append("SELECT");
        if (sqlParams.isDistinct()) {
            sql.append(" DISTINCT");
        }
        String singleField = null;
        Class singleFieldClass = null;
        if (sqlParams.isSingleField()) {
            if (StrKit.isBlank(sqlParams.getSelectColumns()) && StrKit.isBlank(sqlParams.getSelectExpressionColumns())) {
                throw new HORMException("need one column at least");
            }
            singleFieldClass = Object.class;
            if (StrKit.isNotBlank(sqlParams.getSelectColumns())) {
                singleField = sqlParams.getSelectColumns().split(",")[0].trim();
                String actSingleField = this.getRawMappingAttr(singleField, this.escape0, this.escape1);
                String bingoAttr = null;
                Map<String, String> attrs = sqlParams.getAttrs();
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    if (!actSingleField.equals(entry.getKey()) && !actSingleField.equals(entry.getValue())) continue;
                    bingoAttr = entry.getKey();
                }
                if (bingoAttr == null) {
                    throw new HORMException("no field specified");
                }
                Map<String, Field> fieldMap = ModelCacheUtil.getModelFabric(sqlParams.getModelClass()).getFieldMap();
                singleFieldClass = fieldMap.get(bingoAttr).getType();
            }
        }
        boolean hasSelected = false;
        if (StrKit.isNotBlank(sqlParams.getSelectColumns())) {
            sql.append(' ').append(sqlParams.getSelectColumns()).append(' ');
            hasSelected = true;
        } else if (sqlParams.getExcludedColumns() != null && !sqlParams.getExcludedColumns().isEmpty()) {
            sql.append(' ').append(ModelByDialectUtil.buildOracleColumnsByExcluded(sqlParams.getModelClass(), sqlParams.getExcludedColumns())).append(' ');
            hasSelected = true;
        }
        if (StrKit.isNotBlank(sqlParams.getSelectExpressionColumns())) {
            sql.append(hasSelected ? "," : "").append(sqlParams.getSelectExpressionColumns());
        } else if (!hasSelected) {
            sql.append(" * ");
        }
        sql.append("FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(" AND ".length()));
        }
        if (StrKit.isNotBlank(sqlParams.getGroupBy())) {
            sql.append(" GROUP BY").append(sqlParams.getGroupBy());
        }
        if (StrKit.isNotBlank(sqlParams.getOrderBy())) {
            sql.append(" ORDER BY").append(sqlParams.getOrderBy());
        }
        if (StrKit.isNotBlank(sqlParams.getLimitSQL())) {
            sql.append(sqlParams.getLimitSQL());
        }
        int len = sqlParams.getParamValues() == null || sqlParams.getParamValues().isEmpty() ? 0 : sqlParams.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            sqlParams.getParamValues().toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Tuple.apply(sql.toString(), params, singleFieldClass == null ? sqlParams.getModelClass() : singleFieldClass);
    }
}

