/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.dialect.fs.FS;
import cn.sylinx.horm.dialect.fs.FluentSqlParams;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.base.BaseModel;
import cn.sylinx.horm.model.base.Model;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.model.util.ModelByDialectUtil;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SqlBuilder {
    public Tuple buildPaginatorSql(String var1, int var2, int var3);

    public <T> Pair buildDeleteSQL(T var1);

    public <T> Pair buildInsertSQL(T var1);

    public <T> Pair buildBatchInsertSQL(List<T> var1);

    public <T> Pair buildUpdateSQL(T var1);

    public Pair buildDeleteByFieldSQL(List<Pair> var1, Class<?> var2);

    public Pair buildQueryByFieldSQL(List<Pair> var1, Class<?> var2);

    public Pair buildQueryByFieldSQL(List<Pair> var1, Class<?> var2, String[] var3);

    public String buildSimpleQuery(Class<?> var1);

    public String buildSimpleQuery(Class<?> var1, String[] var2);

    public String getTable(Class<?> var1);

    public String getTableColumn(Class<?> var1, String var2);

    public String[] buildCreateTableDDL(Class<?> var1);

    public String buildValidateQuery();

    default public Tuple buildSelectSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(sqlParams.getHint())) {
            sql.append(sqlParams.getHint()).append(" ");
        }
        sql.append("SELECT");
        if (sqlParams.isDistinct()) {
            sql.append(" DISTINCT");
        }
        String singleField = null;
        Class singleFieldClass = null;
        if (sqlParams.isSingleField()) {
            if (StrKit.isBlank(sqlParams.getSelectColumns()) && StrKit.isBlank(sqlParams.getSelectExpressionColumns())) {
                throw new HORMException("need one column at least");
            }
            singleFieldClass = Object.class;
            if (StrKit.isNotBlank(sqlParams.getSelectColumns())) {
                singleField = sqlParams.getSelectColumns().split(",")[0].trim();
                String bingoAttr = null;
                Map<String, String> attrs = sqlParams.getAttrs();
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    if (!singleField.equals(entry.getKey()) && !singleField.equals(entry.getValue())) continue;
                    bingoAttr = entry.getKey();
                }
                if (bingoAttr == null) {
                    throw new HORMException("no field specified");
                }
                Map<String, Field> fieldMap = ModelCacheUtil.getModelFabric(sqlParams.getModelClass()).getFieldMap();
                singleFieldClass = fieldMap.get(bingoAttr).getType();
            }
        }
        boolean hasSelected = false;
        if (StrKit.isNotBlank(sqlParams.getSelectColumns())) {
            sql.append(' ').append(sqlParams.getSelectColumns()).append(' ');
            hasSelected = true;
        } else if (sqlParams.getExcludedColumns() != null && !sqlParams.getExcludedColumns().isEmpty()) {
            sql.append(' ').append(ModelByDialectUtil.buildColumnsByExcluded(sqlParams.getModelClass(), sqlParams.getExcludedColumns())).append(' ');
            hasSelected = true;
        }
        if (StrKit.isNotBlank(sqlParams.getSelectExpressionColumns())) {
            sql.append(hasSelected ? "," : "").append(sqlParams.getSelectExpressionColumns());
        } else if (!hasSelected) {
            sql.append(" * ");
        }
        sql.append("FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(" AND ".length()));
        }
        if (StrKit.isNotBlank(sqlParams.getGroupBy())) {
            sql.append(" GROUP BY").append(sqlParams.getGroupBy());
        }
        if (StrKit.isNotBlank(sqlParams.getOrderBy())) {
            sql.append(" ORDER BY").append(sqlParams.getOrderBy());
        }
        if (StrKit.isNotBlank(sqlParams.getLimitSQL())) {
            sql.append(sqlParams.getLimitSQL());
        }
        int len = sqlParams.getParamValues() == null || sqlParams.getParamValues().isEmpty() ? 0 : sqlParams.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            sqlParams.getParamValues().toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Tuple.apply(sql.toString(), params, singleFieldClass == null ? sqlParams.getModelClass() : singleFieldClass);
    }

    default public Pair buildUpdateSQL(FS<?> fluentSql) {
        String gmtModify;
        FluentSqlParams<?> sqlParams = fluentSql.build();
        ArrayList<Object> paramsUpdate = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(sqlParams.getHint())) {
            sql.append(sqlParams.getHint()).append(" ");
        }
        sql.append("UPDATE ").append(sqlParams.getTableName()).append(" SET ");
        StringBuilder setSQL = new StringBuilder();
        boolean gmtUpdated = false;
        if (null != sqlParams.getUpdateColumnExpression() && !sqlParams.getUpdateColumnExpression().isEmpty()) {
            sqlParams.getUpdateColumnExpression().forEach((key, value) -> setSQL.append((String)key).append(" = ").append((String)value).append(", "));
            if (!gmtUpdated && BaseModel.class.isAssignableFrom(sqlParams.getModelClass())) {
                gmtModify = sqlParams.mapColumn("gmtModify");
                if (!sqlParams.getUpdateColumnExpression().containsKey(gmtModify)) {
                    setSQL.append(gmtModify).append(" = ?, ");
                    paramsUpdate.add(new Date());
                    gmtUpdated = true;
                }
            }
        }
        if (null != sqlParams.getUpdateColumns() && !sqlParams.getUpdateColumns().isEmpty()) {
            sqlParams.getUpdateColumns().forEach((key, value) -> {
                if (value == null) {
                    setSQL.append((String)key).append(" = NULL, ");
                } else {
                    setSQL.append((String)key).append(" = ?, ");
                    paramsUpdate.add(value);
                }
            });
            if (!gmtUpdated && BaseModel.class.isAssignableFrom(sqlParams.getModelClass())) {
                gmtModify = sqlParams.mapColumn("gmtModify");
                if (!sqlParams.getUpdateColumns().containsKey(gmtModify)) {
                    setSQL.append(gmtModify).append(" = ?, ");
                    paramsUpdate.add(new Date());
                    gmtUpdated = true;
                }
            }
        } else if (null != sqlParams.getModel()) {
            ModelFabric mf = ModelCacheUtil.getModelFabric(sqlParams.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            Set<Object> nullableSets = new HashSet();
            if (sqlParams.getModel() instanceof Model) {
                nullableSets = ((Model)sqlParams.getModel()).getNullableFields();
            }
            if (sqlParams.getModel() instanceof BaseModel) {
                ((BaseModel)sqlParams.getModel()).setGmtModify(new Date());
            }
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(sqlParams.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null) continue;
                    boolean nullable = nullableSets.contains(fieldName);
                    if (v != null) {
                        setSQL.append(f).append(" = ?, ");
                        paramsUpdate.add(v);
                        continue;
                    }
                    if (!nullable) continue;
                    setSQL.append(f).append(" = NULL, ");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HORMException("illegal argument or Access:", e);
            }
        }
        sql.append(setSQL.substring(0, setSQL.length() - 2));
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(" AND ".length()));
        }
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        List<Object> paramsListPre = sqlParams.getParamValues();
        if (paramsListPre == null) {
            paramsListPre = new ArrayList<Object>();
        }
        paramsListFinal.addAll(paramsUpdate);
        paramsListFinal.addAll(paramsListPre);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.of(sql.toString(), params);
    }

    default public Pair buildInsertSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder placeholder = new StringBuilder();
        ArrayList<Object> insertParams = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(sqlParams.getHint())) {
            sql.append(sqlParams.getHint()).append(" ");
        }
        sql.append("INSERT INTO ").append(sqlParams.getTableName());
        boolean hasField = false;
        if (null != sqlParams.getUpdateColumns() && !sqlParams.getUpdateColumns().isEmpty()) {
            Map<String, Object> uc = sqlParams.getUpdateColumns();
            Set<Map.Entry<String, Object>> entrySets = uc.entrySet();
            for (Map.Entry<String, Object> entry : entrySets) {
                columnNames.append(",").append(entry.getKey());
                placeholder.append(",?");
                insertParams.add(entry.getValue());
                hasField = true;
            }
            if (BaseModel.class.isAssignableFrom(sqlParams.getModelClass())) {
                String gmtModify = sqlParams.mapColumn("gmtModify");
                if (!sqlParams.getUpdateColumns().containsKey(gmtModify)) {
                    columnNames.append(",").append(gmtModify);
                    placeholder.append(",?");
                    insertParams.add(new Date());
                }
                String gmtCreate = sqlParams.mapColumn("gmtCreate");
                if (!sqlParams.getUpdateColumns().containsKey(gmtCreate)) {
                    columnNames.append(",").append(gmtCreate);
                    placeholder.append(",?");
                    insertParams.add(new Date());
                }
            }
        } else if (null != sqlParams.getModel()) {
            ModelFabric mf = ModelCacheUtil.getModelFabric(sqlParams.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            if (BaseModel.class.isAssignableFrom(sqlParams.getModelClass())) {
                Date c = new Date();
                ((BaseModel)sqlParams.getModel()).setGmtModify(c);
                ((BaseModel)sqlParams.getModel()).setGmtCreate(c);
            }
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(sqlParams.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null || v == null) continue;
                    columnNames.append(",").append(f);
                    placeholder.append(",?");
                    insertParams.add(v);
                    hasField = true;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HORMException("illegal argument or Access:", e);
            }
        }
        if (!hasField) {
            throw new HORMException("no insert field detected");
        }
        sql.append("(").append(columnNames.substring(1)).append(")").append(" VALUES (").append(placeholder.substring(1)).append(")");
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        paramsListFinal.addAll(insertParams);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.of(sql.toString(), params);
    }

    default public Pair buildDeleteSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        ArrayList<Object> paramsDelete = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(sqlParams.getHint())) {
            sql.append(sqlParams.getHint()).append(" ");
        }
        sql.append("DELETE FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(" AND ".length()));
            List<Object> paramsListPre = sqlParams.getParamValues();
            if (paramsListPre == null) {
                paramsListPre = new ArrayList<Object>();
            }
            paramsDelete.addAll(paramsListPre);
        } else if (null != sqlParams.getModel()) {
            StringBuilder columnNames = new StringBuilder();
            ModelFabric mf = ModelCacheUtil.getModelFabric(sqlParams.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            String andStr = " AND ";
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(sqlParams.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null || v == null) continue;
                    columnNames.append(f).append(" = ?").append(andStr);
                    paramsDelete.add(v);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HORMException("illegal argument or Access:", e);
            }
            if (columnNames.length() > 0) {
                sql.append(" WHERE ").append(columnNames.substring(0, columnNames.length() - andStr.length()));
            }
        }
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        paramsListFinal.addAll(paramsDelete);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.of(sql.toString(), params);
    }

    default public Pair buildCountSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        if (!sqlParams.isCount()) {
            throw new HORMException("not count sql");
        }
        StringBuilder sql = new StringBuilder();
        if (StrKit.isNotBlank(sqlParams.getHint())) {
            sql.append(sqlParams.getHint()).append(" ");
        }
        sql.append("SELECT COUNT(*) ");
        sql.append("FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(" AND ".length()));
        }
        int len = sqlParams.getParamValues() == null || sqlParams.getParamValues().isEmpty() ? 0 : sqlParams.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            sqlParams.getParamValues().toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.apply((Object)sql.toString(), (Object)params);
    }
}

