/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.sql;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.EnumDbType;
import cn.sylinx.horm.dialect.sql.ClickHouseSqlBuilder;
import cn.sylinx.horm.dialect.sql.DB2SqlBuilder;
import cn.sylinx.horm.dialect.sql.DefaultSqlBuilder;
import cn.sylinx.horm.dialect.sql.DerbySqlBuilder;
import cn.sylinx.horm.dialect.sql.H2SqlBuilder;
import cn.sylinx.horm.dialect.sql.HsqldbSqlBuilder;
import cn.sylinx.horm.dialect.sql.MySqlSqlBuilder;
import cn.sylinx.horm.dialect.sql.OracleSqlBuilder;
import cn.sylinx.horm.dialect.sql.PostgreSQLSqlBuilder;
import cn.sylinx.horm.dialect.sql.SqlBuilder;
import cn.sylinx.horm.dialect.sql.SqlServerSqlBuilder;
import cn.sylinx.horm.dialect.sql.SqliteSqlBuilder;
import java.util.HashMap;
import java.util.Map;

public class SqlBuilderFactory {
    private final Map<DbType, SqlBuilder> registers = new HashMap<DbType, SqlBuilder>();
    private static final SqlBuilderFactory instance = new SqlBuilderFactory();
    private final DefaultSqlBuilder defaultSqlBuilder = new DefaultSqlBuilder();

    public static SqlBuilderFactory get() {
        return instance;
    }

    private SqlBuilderFactory() {
        this.registerDefault();
    }

    private void registerDefault() {
        this.register(EnumDbType.MYSQL, new MySqlSqlBuilder());
        this.register(EnumDbType.ORACLE, new OracleSqlBuilder());
        this.register(EnumDbType.SQLSERVER, new SqlServerSqlBuilder());
        this.register(EnumDbType.DERBY, new DerbySqlBuilder());
        this.register(EnumDbType.DB2, new DB2SqlBuilder());
        this.register(EnumDbType.POSTGRESQL, new PostgreSQLSqlBuilder());
        this.register(EnumDbType.H2, new H2SqlBuilder());
        this.register(EnumDbType.CLICKHOUSE, new ClickHouseSqlBuilder());
        this.register(EnumDbType.SQLITE, new SqliteSqlBuilder());
        this.register(EnumDbType.HSQLDB, new HsqldbSqlBuilder());
    }

    public void register(DbType dbType, SqlBuilder sqlBuilder) {
        this.registers.put(dbType, sqlBuilder);
    }

    public SqlBuilder getSqlBuilder(DbType dbType) {
        SqlBuilder sb = this.registers.get(dbType);
        if (sb == null) {
            return this.defaultSqlBuilder;
        }
        return sb;
    }
}

