/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.model.base;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.lambda.TypeFunction;
import cn.sylinx.horm.util.LambdaUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Model
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String NULLABLE_FIELDS = "NULLABLE_FIELDS";
    private Map<String, Object> context = new HashMap<String, Object>();

    public Map<String, Object> getContext() {
        return this.context;
    }

    public <T extends Model> T withNullable(String attributeName) {
        this.getNullableFields().add(attributeName);
        return (T)this;
    }

    public <T extends Model, R> T withNullable(TypeFunction<T, R> lambda) {
        return this.withNullable(LambdaUtil.getLambdaFieldName(lambda));
    }

    public <T extends Model> T withNullables(String ... attributeNames) {
        if (attributeNames != null) {
            for (String attributeName : attributeNames) {
                this.getNullableFields().add(attributeName);
            }
        }
        return (T)this;
    }

    public <T extends Model, R> T withNullables(TypeFunction<T, R> ... lambdaArray) {
        for (int i = 0; i < lambdaArray.length; ++i) {
            this.getNullableFields().add(LambdaUtil.getLambdaFieldName(lambdaArray[i]));
        }
        return (T)this;
    }

    public <T extends Model> T removeNullable() {
        this.getNullableFields().clear();
        return (T)this;
    }

    public <T extends Model> T withNullable() {
        List<Field> fieldList = ModelCacheUtil.getObjectAllFieldsWithcache(this.getClass());
        for (Field f : fieldList) {
            this.withNullable(f.getName());
        }
        return (T)this;
    }

    public Set<String> getNullableFields() {
        HashSet object = this.context.get(NULLABLE_FIELDS);
        if (object == null) {
            object = new HashSet();
            this.context.put(NULLABLE_FIELDS, object);
        }
        return object;
    }

    public Object clone() {
        Model cloneObject = null;
        try {
            cloneObject = (Model)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HORMException(e);
        }
        if (cloneObject != null) {
            cloneObject.context = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.context.entrySet()) {
                cloneObject.context.put(entry.getKey(), entry.getValue());
            }
        }
        return cloneObject;
    }
}

