/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.ProxyFactory;
import cn.sylinx.horm.proxy.ProxyObject;
import cn.sylinx.horm.proxy.ProxyType;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ProxyObjectRegistry {
    INSTANCE;

    private final Map<Class<?>, ProxyFactory<?>> proxyFactoryMaps = new HashMap();

    public <T> boolean has(Class<T> type) {
        return this.proxyFactoryMaps.containsKey(type);
    }

    public <T> void register(Class<T> type) {
        if (type.isInterface()) {
            if (this.has(type)) {
                throw new HORMException("Type " + type + " is already known to the ProxyFactoryRegistry.");
            }
            this.proxyFactoryMaps.put(type, new ProxyFactory<T>(type));
            GLog.debug("h-orm proxy: {} registry ok", type.getName());
        }
    }

    public <T> void register(String className) {
        Class<?> type = null;
        ClassLoader clToUse = ClassUtil.getDefaultClassLoader();
        try {
            type = Class.forName(className, false, clToUse);
        }
        catch (Exception e) {
            GLog.error("no class defined", e);
        }
        if (type == null) {
            return;
        }
        this.register(type);
    }

    public <T> T getCommand(Class<T> type) {
        return this.get(type, ProxyType.command);
    }

    public <T> T getMapper(Class<T> type) {
        return this.get(type, ProxyType.mapper);
    }

    private <T> T get(Class<T> type, ProxyType proxyType) {
        ProxyFactory<?> ProxyFactory2 = this.proxyFactoryMaps.get(type);
        if (ProxyFactory2 == null) {
            throw new HORMException("Type " + type + " is not known to the ProxyFactoryRegistry.");
        }
        try {
            return (T)ProxyFactory2.newInstance(new ProxyObject<T>(type, proxyType));
        }
        catch (Exception e) {
            throw new HORMException("Error getting proxy instance. Cause: " + e, e);
        }
    }

    public Collection<Class<?>> getAllProxyClass() {
        return Collections.unmodifiableCollection(this.proxyFactoryMaps.keySet());
    }
}

