/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy.command;

import cn.sylinx.horm.core.datasource.dynamic.DynamicDatasourceProvider;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.annotation.PageNumber;
import cn.sylinx.horm.proxy.annotation.PageSize;
import cn.sylinx.horm.proxy.annotation.Param;
import cn.sylinx.horm.proxy.annotation.ParamBean;
import cn.sylinx.horm.proxy.command.annotation.Command;
import cn.sylinx.horm.proxy.command.annotation.Datasource;
import cn.sylinx.horm.proxy.command.annotation.Resource;
import cn.sylinx.horm.util.BeanUtil;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CommandMethodMetadata {
    private static final Map<String, CommandMethodMetadata> cachedMethod = new HashMap<String, CommandMethodMetadata>();
    private Class<?> commandInterface;
    private Command commandAnnotation;
    private Method method;
    private Class<?> truelyReturnType;
    private Annotation[][] parameterAnnotations;
    private Resource resource;
    private String truelyDatasource;
    private Class<?> returnType;
    private boolean nativeSql = false;
    private String metaKey;

    private static String getMetaKey(Class<?> commandInterface, Method method) {
        return commandInterface.getName() + "." + method.toString();
    }

    public static CommandMethodMetadata get(Class<?> commandInterface, Method method) {
        String key = CommandMethodMetadata.getMetaKey(commandInterface, method);
        CommandMethodMetadata methodMetadata = CommandMethodMetadata.get(key);
        if (methodMetadata == null) {
            methodMetadata = CommandMethodMetadata.setAndGet(key, commandInterface, method);
        }
        return methodMetadata;
    }

    private static CommandMethodMetadata get(String key) {
        return cachedMethod.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommandMethodMetadata setAndGet(String key, Class<?> commandInterface, Method method) {
        String string = key.intern();
        synchronized (string) {
            CommandMethodMetadata methodMetadata = CommandMethodMetadata.get(key);
            if (methodMetadata != null) {
                return methodMetadata;
            }
            methodMetadata = new CommandMethodMetadata(commandInterface, method);
            cachedMethod.put(key, methodMetadata);
            return methodMetadata;
        }
    }

    public CommandMethodMetadata(Class<?> commandInterface, Method method) {
        this.commandInterface = commandInterface;
        this.method = method;
        this.readMetadata();
    }

    private void readMetadata() {
        this.commandAnnotation = this.readCommandAnnotation();
        this.returnType = this.readReturnType();
        this.truelyReturnType = this.readTruelyReturnType();
        this.parameterAnnotations = this.readParameterAnnotations();
        this.resource = this.readAndCheckResource();
        this.truelyDatasource = this.readTruelyDatasource();
        this.nativeSql = this.resource.nativeSql() != null && !"".equals(this.resource.nativeSql().trim());
        this.metaKey = CommandMethodMetadata.getMetaKey(this.commandInterface, this.method);
    }

    private Class<?> readReturnType() {
        return this.method.getReturnType();
    }

    private Command readCommandAnnotation() {
        return this.commandInterface.getAnnotation(Command.class);
    }

    private Annotation[][] readParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    private Resource readAndCheckResource() {
        boolean isNativeSqlNull;
        Resource resource = this.method.getAnnotation(Resource.class);
        if (resource == null) {
            throw new HORMException("sql resource is empty");
        }
        String sqlResource = resource.sql();
        String nativeSql = resource.nativeSql();
        boolean isSqlResourceNull = sqlResource == null || "".equals(sqlResource.trim());
        boolean bl = isNativeSqlNull = nativeSql == null || "".equals(nativeSql.trim());
        if (isSqlResourceNull && isNativeSqlNull) {
            throw new HORMException("SQL\u8d44\u6e90\u548c\u672c\u5730SQL\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        return resource;
    }

    public Tuple resove(Object[] args) {
        Integer pageNumber = 0;
        Integer pageSize = 0;
        ArrayList<Pair> paramList = new ArrayList<Pair>();
        ArrayList<Map> mapList = new ArrayList<Map>();
        ArrayList<Object> beanList = new ArrayList<Object>();
        ArrayList<String> datasourceList = new ArrayList<String>();
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            Annotation[] ats = this.parameterAnnotations[i];
            if (ats != null && ats.length > 0) {
                Object dsObject;
                if (ats[0].annotationType() == PageNumber.class) {
                    pageNumber = (Integer)args[i];
                }
                if (ats[0].annotationType() == PageSize.class) {
                    pageSize = (Integer)args[i];
                }
                if (ats[0].annotationType() == Param.class) {
                    paramList.add(Pair.apply((Object)ats[0], args[i]));
                }
                if (ats[0].annotationType() == ParamBean.class) {
                    beanList.add(args[i]);
                }
                if (ats[0].annotationType() == Datasource.class && (dsObject = args[i]) != null) {
                    if (dsObject.getClass() != String.class) {
                        throw new HORMException("\u6570\u636e\u6e90\u7c7b\u578b\u9519\u8bef");
                    }
                    datasourceList.add(dsObject.toString());
                }
            }
            if (args[i] == null || !Map.class.isAssignableFrom(args[i].getClass())) continue;
            mapList.add((Map)args[i]);
        }
        if (datasourceList.size() > 1) {
            throw new HORMException("\u4e0d\u80fd\u914d\u7f6e\u591a\u4e2a\u6570\u636e\u6e90");
        }
        String datasource = null;
        if (!datasourceList.isEmpty()) {
            datasource = (String)datasourceList.get(0);
        }
        if (datasource == null) {
            datasource = this.truelyDatasource;
        }
        HashMap ps = new HashMap();
        paramList.forEach(p -> {
            Param param = (Param)p.getObject(0);
            ps.put(param.value(), p.getObject(1));
        });
        mapList.forEach(map -> map.entrySet().forEach(entry -> ps.put((String)entry.getKey(), entry.getValue())));
        beanList.forEach(bean -> ps.putAll(BeanUtil.bean2map(bean)));
        if (pageNumber == null || pageNumber < 1) {
            pageNumber = Optional.ofNullable((Integer)ps.get("pageNumber")).orElse(0);
            pageSize = Optional.ofNullable((Integer)ps.get("pageSize")).orElse(0);
        }
        if (this.commandAnnotation.dynamic()) {
            datasource = DynamicDatasourceProvider.create().getDatasource();
        }
        return Tuple.apply(ps, pageNumber, pageSize, datasource);
    }

    private String readTruelyDatasource() {
        String globalDatasource;
        String datasourcePre = this.commandAnnotation.datasource().trim();
        String truelyDatasource = globalDatasource = StrKit.isEmpty(datasourcePre) ? null : datasourcePre;
        String datasource = this.resource.datasource().trim();
        if (datasource != null && !"".equals(datasource)) {
            truelyDatasource = datasource;
        }
        if (StrKit.isBlank(truelyDatasource)) {
            truelyDatasource = "_DEFAULT_DS_NAME_FOR_HORM_";
        }
        return truelyDatasource;
    }

    private Class<?> readTruelyReturnType() {
        Type genericReturnType = this.method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return Object.class;
    }

    public Class<?> getTruelyReturnType() {
        return this.truelyReturnType;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Class<?> getCommandInterface() {
        return this.commandInterface;
    }

    public Command getCommandAnnotation() {
        return this.commandAnnotation;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean isNativeSql() {
        return this.nativeSql;
    }

    public String getMetaKey() {
        return this.metaKey;
    }

    public void setMetaKey(String metaKey) {
        this.metaKey = metaKey;
    }
}

