/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.func;

import cn.sylinx.horm.resource.func.IFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class FunctionFactory {
    private final Map<String, IFunction> registers = new HashMap<String, IFunction>();
    private static final FunctionFactory instance = new FunctionFactory();

    public static FunctionFactory get() {
        return instance;
    }

    private FunctionFactory() {
        this.registerDefaultFunctions();
    }

    private void registerDefaultFunctions() {
        ServiceLoader<IFunction> sl = ServiceLoader.load(IFunction.class);
        if (sl != null) {
            Iterator<IFunction> funit = sl.iterator();
            while (funit.hasNext()) {
                this.register(funit.next());
            }
        }
    }

    public IFunction getFunction(String alias) {
        return this.registers.get(alias);
    }

    public void register(IFunction f) {
        this.registers.put(f.sqlAlias(), f);
    }
}

