package cn.sylinx.horm.core.common;

import cn.sylinx.horm.transaction.jdbc.TransactionIsolation;

/**
 * 事务信息
 * 
 * @author johnhan
 *
 */
public class TransInfo {
    private int transactionIsolation = TransactionIsolation.ME.getTransactionIsolation();
    private long beginTime;
    private long endTime;

    public TransInfo() {
        this(TransactionIsolation.ME.getTransactionIsolation());
    }

    public TransInfo(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
        beginTime = System.currentTimeMillis();
    }

    public int getTransactionIsolation() {
        return transactionIsolation;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public String toString() {
        return "TransInfo [transactionIsolation=" + transactionIsolation + ", beginTime=" + beginTime + ", endTime="
                + endTime + "]";
    }

}
