package cn.sylinx.horm.core.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

import javax.sql.DataSource;

import cn.sylinx.horm.util.ClassUtil;

enum DataSourceShutterManager {

    INSTANCE;

    private List<DataSourceShutter> dataSourceShutterList = new ArrayList<>();

    private DataSourceShutterManager() {
        loadFromService();
    }

    private final void loadFromService() {
        ServiceLoader<DataSourceShutter> serviceLoader = ServiceLoader.load(DataSourceShutter.class,
                ClassUtil.getDefaultClassLoader());
        if (serviceLoader != null) {
            Iterator<DataSourceShutter> it = serviceLoader.iterator();
            while (it != null && it.hasNext()) {
                dataSourceShutterList.add(it.next());
            }
        }
    }

    boolean close(DataSource dataSource) {

        for (DataSourceShutter dataSourceShutter : dataSourceShutterList) {
            if (dataSourceShutter.close(dataSource)) {
                return true;
            }
        }
        return false;
    }
}
