package cn.sylinx.horm.core.stat;

/**
 * sql 执行拦截处理
 * 
 * @author johnhan
 *
 */
public interface SqlExecutedHandler {

    /**
     * 执行超时
     * 
     * @param datasoureName
     * @param nativeSql
     * @param thresholdMillSeconds
     */
    void onTimeout(String datasoureName, String nativeSql, long thresholdMillSeconds);

    /**
     * 执行完毕，可能出现错误
     * 
     * @param datasoureName
     * @param nativeSql
     * @param usedTime
     * @param error
     */
    void onDone(String datasoureName, String nativeSql, Long usedTime, Throwable error);
}
