package cn.sylinx.horm.dialect;

import cn.sylinx.horm.dialect.spi.DialectSPIManager;
import cn.sylinx.horm.exception.HORMException;

/**
 * 数据库类型，实现建议使用单例
 * 
 * @author johnhan
 *
 */
public interface DbType {

    public String getValue();

    public static DbType getDbType(String dbTypeStr) {

        DbType[] dbts = EnumDbType.values();
        for (DbType item : dbts) {
            if (item.getValue().equalsIgnoreCase(dbTypeStr)) {
                return item;
            }
        }

        Dialect dialect = DialectSPIManager.createDialectBySPI(dbTypeStr);
        if (dialect == null) {
            throw new HORMException("不支持的数据库类型：" + dbTypeStr);
        }

        return dialect.getDbType();
    }

}
