package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

public interface FSBuilder {

    default <T> FS<T> build(Class<T> modelClass) {
        return FS.of(modelClass);
    }

    default <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
        return FS.of(modelClass, tablePostfix);
    }

    default <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
        return FS.of(tablePrefix, modelClass);
    }

    default <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return FS.of(tablePrefix, modelClass, tablePostfix);
    }
}
