package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class OracleFSBuilder implements FSBuilder {

    @Override
    public <T> FS<T> build(Class<T> modelClass) {
        return OracleFS.of(modelClass);
    }

    @Override
    public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
        return OracleFS.of(modelClass, tablePostfix);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
        return OracleFS.of(tablePrefix, modelClass);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return OracleFS.of(tablePrefix, modelClass, tablePostfix);
    }

}
