package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class PostgreSqlFSBuilder implements FSBuilder {

    @Override
    public <T> FS<T> build(Class<T> modelClass) {
        return PostgreSqlFS.of(modelClass);
    }

    @Override
    public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
        return PostgreSqlFS.of(modelClass, tablePostfix);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
        return PostgreSqlFS.of(tablePrefix, modelClass);
    }

    @Override
    public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return PostgreSqlFS.of(tablePrefix, modelClass, tablePostfix);
    }

}
