package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class SqlserverFS<T> extends FS<T> {

    public static <T> FS<T> of(Class<T> modelClass) {
        return new SqlserverFS<T>().init(modelClass);
    }

    public static <T> FS<T> of(Class<T> modelClass, String tablePostfix) {
        return new SqlserverFS<T>().init(modelClass, tablePostfix);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass) {
        return new SqlserverFS<T>().init(tablePrefix, modelClass);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return new SqlserverFS<T>().init(tablePrefix, modelClass, tablePostfix);
    }

    @Override
    protected String[] getEscape() {
        return new String[] { "[", "]" };
    }

    public FS<T> limit(int size) {
        if (limitSQL.length() == 0) {
            limitSQL.append(" TOP ").append(size).append(" ");
        }
        return this;
    }
}
