package cn.sylinx.horm.dialect.sql;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.util.Tuple;

class OracleSqlBuilder extends DefaultSqlBuilder {

    protected String[] getEscapeChar() {
        return new String[] { "\"", "\"" };
    }

    @Override
    protected boolean toUpperCase() {
        return true;
    }

    @Override
    public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {

        // 计算总数sql
        String sqlCount = "SELECT count(1) as totalCount from (" + preSql + ")";

        int offsetBegin = pageSize * (pageNumber - 1);
        int offsetEnd = offsetBegin + pageSize;

        // 查询分页sql
        String sqlLimit = "SELECT /*+ FIRST_ROWS */ * FROM (SELECT A.*, ROWNUM RN FROM (" + preSql
                + ") A  WHERE ROWNUM <= ?) WHERE RN > ? ";
        Object[] params = new Object[] { offsetEnd, offsetBegin };
        return Tuple.apply(sqlCount, sqlLimit, params);
    }

    @Override
    public String buildValidateQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String getTable(Class<?> clz) {
        String table = ModelCacheUtil.getModelFabric(clz).getTableName();
        return table.toUpperCase();
    }

    @Override
    public String getTableColumn(Class<?> clz, String prop) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrMap = mf.getAttrMapping();
        String column = attrMap.get(prop);
        if (column == null) {
            column = prop;
        }
        return column.toUpperCase();
    }

    @Override
    public String buildExcludedColumns(Class<?> clz, List<String> excludedColumns, boolean useSymbol, String preEscape,
            String postEscape) {

        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrs = mf.getRawAttrMapping();
        Set<String> columns = new HashSet<String>();
        Set<Entry<String, String>> kvsets = attrs.entrySet();
        for (Entry<String, String> entry : kvsets) {
            if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue())
                    || excludedColumns.contains(entry.getValue().toLowerCase())) {
                continue;
            }
            columns.add(preEscape + entry.getValue().toUpperCase() + postEscape);
        }

        StringBuilder sb = new StringBuilder();
        columns.forEach(k -> sb.append(k).append(","));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

}
