package cn.sylinx.horm.proxy.command.invoker;

import java.util.List;
import java.util.Map;

import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.proxy.command.CommandMethodMetadata;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.util.Tuple;

class BeanQueryOneCommandInvoker extends AbstractCommandInvoker {

    @Override
    public Object invoke(CommandMethodMetadata methodMetadata, Tuple tuple) {

        Map<String, Object> params = tuple.getObject(0);
        String truelyDatasource = tuple.getObject(3);
        String nativeSql = methodMetadata.getResource().nativeSql();
        String sql = methodMetadata.getResource().sql();
        Class<?> returnType = methodMetadata.getReturnType();
        SqlClient ormClient = getClient(truelyDatasource);

        // 使用native sql
        boolean isNativeSql = nativeSql != null && !"".equals(nativeSql.trim());
        if (isNativeSql) {
            Tuple t = ormClient.getSqlParser().parseSql(nativeSql, params, null);
            String truelyNativeSql = t.getObject(0);
            Object[] truelyParams = t.getObject(1);
            List<?> dataList = ormClient.queryList(truelyNativeSql, truelyParams, returnType);
            return dataList == null || dataList.isEmpty() ? null : dataList.get(0);
        }

        return ormClient.queryFirst(new ClasspathSqlResource(sql), params, returnType);
    }
}