package cn.sylinx.horm.resource.func.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.func.IFunction;
import cn.sylinx.horm.resource.parse.ValueTokenHandler;
import cn.sylinx.horm.util.StrKit;

/**
 * 包含操作<br>
 * 使用方法 #FUNC[include,field,params], 接收一个参数 params, 默认使用 or 组合<br>
 * #FUNC[include,field,params,0] 使用 or 组合<br>
 * #FUNC[include,field,params,1] 使用 in
 * 
 * @author han
 *
 */
public class Include implements IFunction {

    public Include() {
    }

    @Override
    public String sqlAlias() {
        return "include";
    }

    @SuppressWarnings({ "rawtypes" })
    @Override
    public String invoke(ValueTokenHandler valueTokenHandler, String inputStr) {

        String[] kv = inputStr.split(",");
        if (kv == null || kv.length < 2) {
            throw new HORMException(sqlAlias() + "函数的入参错误");
        }

        String field = kv[0].trim();
        String params = kv[1].trim();
        String type = null;

        Optional<Object> optional = Optional.of(valueTokenHandler.handle(params));
        Object value = optional.get();

        if (kv.length == 3) {
            type = kv[2].trim();
        }

        if (StrKit.isBlank(type)) {
            type = "0";
        }

        boolean useOr = "0".equals(type); // 使用 or

        List<String> valueList = new ArrayList<String>();

        if (value.getClass().isArray()) {
            // 是数组
            Object[] ary = (Object[]) value;
            for (Object v : ary) {

                if (v instanceof Number) {
                    valueList.add(v.toString());
                } else {
                    valueList.add("'" + v.toString() + "'");
                }
            }

        } else if (value instanceof Collection) {
            // 集合类型处理

            Collection c = (Collection) value;
            Iterator it = c.iterator();
            while (it.hasNext()) {

                Object v = it.next();
                if (v instanceof Number) {
                    valueList.add(v.toString());
                } else {
                    valueList.add("'" + v.toString() + "'");
                }
            }

        } else if (value instanceof Number) {
            // 数字类型
            valueList.add(value.toString());

        } else {
            // 当做字符串处理
            valueList.add("'" + value.toString() + "'");
        }

        StringBuilder sb = new StringBuilder();

        if (valueList.size() == 1) {
            // 只有一个值，使用 =
            sb.append(" ").append(field).append(" = ").append(valueList.get(0));

        } else {
            // 否则使用in

            if (useOr) {

                String token = " OR ";
                sb.append(" ").append("(");
                for (String item : valueList) {
                    sb.append(field).append(" = ").append(item).append(token);
                }
                sb.delete(sb.length() - token.length(), sb.length());
                sb.append(")").append(" ");

            } else {

                sb.append(" ").append(field).append(" ");
                sb.append("in (");
                for (String item : valueList) {
                    sb.append(item).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")").append(" ");
            }

        }

        return sb.toString();
    }

}
