
package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.sylinx.horm.type.JdbcType;

public class FloatTypeHandler extends BaseTypeHandler<Float> {

    @Override
    protected JdbcType getJdbcTypeMapper() {
        return JdbcType.FLOAT;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Float parameter) throws SQLException {
        ps.setFloat(i, parameter);
    }

    @Override
    public Float getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return rs.getFloat(columnName);
    }

    @Override
    public Float getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getFloat(columnIndex);
    }

    @Override
    public Float getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getFloat(columnIndex);
    }
}
