package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.YearMonth;

import cn.sylinx.horm.type.JdbcType;

public class YearMonthTypeHandler extends BaseTypeHandler<YearMonth> {

    @Override
    protected JdbcType getJdbcTypeMapper() {
        return JdbcType.VARCHAR;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, YearMonth yearMonth) throws SQLException {
        ps.setString(i, yearMonth.toString());
    }

    @Override
    public YearMonth getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return value == null ? null : YearMonth.parse(value);
    }

    @Override
    public YearMonth getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        return value == null ? null : YearMonth.parse(value);
    }

    @Override
    public YearMonth getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        return value == null ? null : YearMonth.parse(value);
    }

}
