package cn.sylinx.horm.util;

import cn.sylinx.horm.exception.HORMException;

public class Pair extends Tuple {

    public static Pair of(Object key, Object value) {
        return new Pair(key, value);
    }

    public static Pair apply(Object key, Object value) {
        return of(key, value);
    }

    public Pair(Object key, Object value) {
        super(new Object[] { key, value });
    }

    public <T> T getKey() {
        return getObject(0);
    }

    public <T> T getValue() {
        return getObject(1);
    }

    @Override
    public void setItems(Object[] items) {

        if (items == null || items.length != 2) {
            throw new HORMException("invalid pair");
        }

        super.setItems(items);
    }

}
