/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.CacheLoader;
import cn.sylinx.horm.config.CommandInterceptorLoader;
import cn.sylinx.horm.config.CommandLoader;
import cn.sylinx.horm.config.MapStrategyLoader;
import cn.sylinx.horm.config.MapperInterceptorLoader;
import cn.sylinx.horm.config.MapperLoader;
import cn.sylinx.horm.config.ModelCacheLoader;
import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.config.ServiceEnvironment;
import cn.sylinx.horm.config.SqlClientInterceptorLoader;
import cn.sylinx.horm.config.SqlResourceLoader;
import cn.sylinx.horm.config.TransactionIsolationLoader;
import cn.sylinx.horm.core.interceptor.SqlClientInterceptor;
import cn.sylinx.horm.core.stat.SqlStatManager;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.command.interceptor.CommandInterceptor;
import cn.sylinx.horm.proxy.mapper.interceptor.MapperInterceptor;
import cn.sylinx.horm.util.GLog;
import java.util.concurrent.atomic.AtomicBoolean;

public final class OrmConfigHolder
extends Enum<OrmConfigHolder> {
    private static final AtomicBoolean inited;
    private static OrmConfig ormConfig;
    private static ServiceEnvironment serviceEnvironment;
    private static SqlClientInterceptor sqlClientInterceptor;
    private static CommandInterceptor commandInterceptor;
    private static MapperInterceptor mapperInterceptor;
    private static final /* synthetic */ OrmConfigHolder[] $VALUES;

    public static OrmConfigHolder[] values() {
        return (OrmConfigHolder[])$VALUES.clone();
    }

    public static OrmConfigHolder valueOf(String name) {
        return Enum.valueOf(OrmConfigHolder.class, name);
    }

    public static synchronized void init(ServiceEnvironment serviceEnvironment, OrmConfig ormConfig) {
        if (inited.get()) {
            GLog.info("\u5df2\u521d\u59cb\u5316", new Object[0]);
            return;
        }
        try {
            OrmConfigHolder.initInner(serviceEnvironment, ormConfig);
        }
        catch (Exception e) {
            GLog.error("\u521d\u59cb\u5316\u5f02\u5e38", e);
            throw new HORMException("\u521d\u59cb\u5316\u5f02\u5e38", e);
        }
        finally {
            inited.set(true);
        }
    }

    private static void initInner(ServiceEnvironment serviceEnvironment, OrmConfig ormConfig) {
        OrmConfigHolder.serviceEnvironment = serviceEnvironment;
        OrmConfigHolder.ormConfig = (OrmConfig)ormConfig.clone();
        OrmConfigHolder.initConfig();
        GLog.info("\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f, OrmConifg:{}", OrmConfigHolder.ormConfig);
    }

    private static void initConfig() {
        if (!OrmConfigHolder.isDebug() && OrmConfigHolder.isCache()) {
            new CacheLoader(ormConfig).initCache();
        }
        if (!OrmConfigHolder.isDebug()) {
            new SqlResourceLoader(ormConfig).load();
        }
        if (OrmConfigHolder.isNormalJavaEnv()) {
            new CommandLoader(ormConfig).load();
            new MapperLoader(ormConfig).load();
            new TransactionIsolationLoader(ormConfig).load();
        }
        new MapStrategyLoader(ormConfig).load();
        if (OrmConfigHolder.isNormalJavaEnv() && !OrmConfigHolder.isDebug() && ormConfig.isCacheModelOnStart()) {
            new ModelCacheLoader(ormConfig).load();
        }
        sqlClientInterceptor = new SqlClientInterceptorLoader(ormConfig).load();
        commandInterceptor = new CommandInterceptorLoader(ormConfig).load();
        mapperInterceptor = new MapperInterceptorLoader(ormConfig).load();
        if (OrmConfigHolder.isSqlStatOpen()) {
            SqlStatManager.start();
        }
    }

    public static OrmConfig getOrmConfig() {
        return (OrmConfig)ormConfig.clone();
    }

    private static boolean isNormalJavaEnv() {
        return ServiceEnvironment.NORMAL == serviceEnvironment;
    }

    public static ServiceEnvironment getServiceEnvironment() {
        return serviceEnvironment;
    }

    public static boolean isDebug() {
        return ormConfig.isDebug();
    }

    public static boolean isSqlStatOpen() {
        return ormConfig.isSqlStatOpen() && ormConfig.getSqlExecuteTimeThreshold() > 100L;
    }

    public static boolean isCache() {
        return ormConfig.isCache();
    }

    public static boolean isOptimisticLockEnable() {
        return ormConfig.isOptimisticLockEnable();
    }

    public static boolean isCaseSensitive() {
        return ormConfig.isCaseSensitive();
    }

    public static long getSqlExecuteTimeThreshold() {
        return ormConfig.getSqlExecuteTimeThreshold();
    }

    public static SqlClientInterceptor getSqlClientInterceptor() {
        return sqlClientInterceptor;
    }

    public static boolean hasSqlClientInterceptor() {
        return sqlClientInterceptor != null;
    }

    public static CommandInterceptor getCommandInterceptor() {
        return commandInterceptor;
    }

    public static boolean hasCommandInterceptor() {
        return commandInterceptor != null;
    }

    public static MapperInterceptor getMapperInterceptor() {
        return mapperInterceptor;
    }

    public static boolean hasMapperInterceptor() {
        return mapperInterceptor != null;
    }

    private static /* synthetic */ OrmConfigHolder[] $values() {
        return new OrmConfigHolder[0];
    }

    static {
        $VALUES = OrmConfigHolder.$values();
        inited = new AtomicBoolean(false);
        ormConfig = new OrmConfig();
        serviceEnvironment = ServiceEnvironment.NORMAL;
        sqlClientInterceptor = null;
        commandInterceptor = null;
        mapperInterceptor = null;
    }
}

