/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.ProxyType;
import cn.sylinx.horm.proxy.command.CommandMethodMetadata;
import cn.sylinx.horm.proxy.command.invoker.CommandInvokerManager;
import cn.sylinx.horm.proxy.mapper.MapperMethodMetadata;
import cn.sylinx.horm.proxy.mapper.invoker.MapperInvokerManager;
import cn.sylinx.horm.util.Tuple;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyObject<T>
implements InvocationHandler {
    private Class<T> interfaceClass;
    private ProxyType proxyType;

    public ProxyObject() {
    }

    public ProxyObject(Class<T> interfaceClass, ProxyType proxyType) {
        this.interfaceClass = interfaceClass;
        this.proxyType = proxyType;
    }

    public Class<T> getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (ProxyType.command == this.proxyType) {
            return this.invokeCommand(proxy, method, args);
        }
        if (ProxyType.mapper == this.proxyType) {
            return this.invokeMapper(proxy, method, args);
        }
        throw new HORMException("invalid proxy type");
    }

    private Object invokeMapper(Object proxy, Method method, Object[] args) throws Throwable {
        MapperMethodMetadata metadata = MapperMethodMetadata.get(this.getInterfaceClass(), method);
        Tuple tuple = metadata.resove(args);
        return this.invokerMapperInner(metadata, tuple);
    }

    private Object invokerMapperInner(MapperMethodMetadata metadata, Tuple tuple) {
        return MapperInvokerManager.getBy(metadata).invoke(metadata, tuple);
    }

    private Object invokeCommand(Object proxy, Method method, Object[] args) throws Throwable {
        CommandMethodMetadata metadata = CommandMethodMetadata.get(this.getInterfaceClass(), method);
        Tuple tuple = metadata.resove(args);
        return this.invokeCommandInner(metadata, tuple);
    }

    private Object invokeCommandInner(CommandMethodMetadata metadata, Tuple tuple) {
        return CommandInvokerManager.getBy(metadata).invoke(metadata, tuple);
    }
}

