/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.type.handler;

import cn.sylinx.horm.type.JdbcType;
import cn.sylinx.horm.type.handler.BaseTypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;

public class LocalDateTimeTypeHandler
extends BaseTypeHandler<LocalDateTime> {
    @Override
    protected JdbcType getJdbcTypeMapper() {
        return JdbcType.TIMESTAMP;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter) throws SQLException {
        ps.setTimestamp(i, Timestamp.valueOf(parameter));
    }

    @Override
    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnName);
        return LocalDateTimeTypeHandler.getLocalDateTime(timestamp);
    }

    @Override
    public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnIndex);
        return LocalDateTimeTypeHandler.getLocalDateTime(timestamp);
    }

    @Override
    public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp timestamp = cs.getTimestamp(columnIndex);
        return LocalDateTimeTypeHandler.getLocalDateTime(timestamp);
    }

    private static LocalDateTime getLocalDateTime(Timestamp timestamp) {
        if (timestamp != null) {
            return timestamp.toLocalDateTime();
        }
        return null;
    }
}

