/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.dao.support;

import cn.taketoday.dao.DataAccessException;
import cn.taketoday.dao.support.PersistenceExceptionTranslator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.ArrayList;

public class ChainedPersistenceExceptionTranslator
implements PersistenceExceptionTranslator {
    private final ArrayList<PersistenceExceptionTranslator> delegates = new ArrayList(4);

    public final void addDelegate(PersistenceExceptionTranslator pet) {
        Assert.notNull((Object)pet, (String)"PersistenceExceptionTranslator must not be null");
        this.delegates.add(pet);
    }

    public final PersistenceExceptionTranslator[] getDelegates() {
        return this.delegates.toArray(new PersistenceExceptionTranslator[0]);
    }

    @Override
    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        for (PersistenceExceptionTranslator pet : this.delegates) {
            DataAccessException translatedDex = pet.translateExceptionIfPossible(ex);
            if (translatedDex == null) continue;
            return translatedDex;
        }
        return null;
    }
}

