/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.dao.support;

import cn.taketoday.dao.DataAccessException;
import cn.taketoday.dao.EmptyResultDataAccessException;
import cn.taketoday.dao.IncorrectResultSizeDataAccessException;
import cn.taketoday.dao.TypeMismatchDataAccessException;
import cn.taketoday.dao.support.PersistenceExceptionTranslator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.NumberUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class DataAccessUtils {
    @Nullable
    public static <T> T singleResult(@Nullable Collection<T> results) throws IncorrectResultSizeDataAccessException {
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return results.iterator().next();
    }

    @Nullable
    public static <T> T singleResult(@Nullable Stream<T> results) throws IncorrectResultSizeDataAccessException {
        if (results == null) {
            return null;
        }
        try (Stream<T> stream = results;){
            List<T> resultList = results.limit(2L).toList();
            if (resultList.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            T t = resultList.isEmpty() ? null : (T)resultList.get(0);
            return t;
        }
    }

    @Nullable
    public static <T> T singleResult(@Nullable Iterator<T> results) throws IncorrectResultSizeDataAccessException {
        T result;
        if (results == null) {
            return null;
        }
        T t = result = results.hasNext() ? (T)results.next() : null;
        if (results.hasNext()) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return result;
    }

    public static <T> Optional<T> optionalResult(@Nullable Collection<T> results) throws IncorrectResultSizeDataAccessException {
        return Optional.ofNullable(DataAccessUtils.singleResult(results));
    }

    public static <T> Optional<T> optionalResult(@Nullable Stream<T> results) throws IncorrectResultSizeDataAccessException {
        return Optional.ofNullable(DataAccessUtils.singleResult(results));
    }

    public static <T> Optional<T> optionalResult(@Nullable Iterator<T> results) throws IncorrectResultSizeDataAccessException {
        return Optional.ofNullable(DataAccessUtils.singleResult(results));
    }

    public static <T> T requiredSingleResult(@Nullable Collection<T> results) throws IncorrectResultSizeDataAccessException {
        if (CollectionUtils.isEmpty(results)) {
            throw new EmptyResultDataAccessException(1);
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return results.iterator().next();
    }

    @Nullable
    public static <T> T nullableSingleResult(@Nullable Collection<T> results) throws IncorrectResultSizeDataAccessException {
        if (CollectionUtils.isEmpty(results)) {
            throw new EmptyResultDataAccessException(1);
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return results.iterator().next();
    }

    @Nullable
    public static <T> T uniqueResult(@Nullable Collection<T> results) throws IncorrectResultSizeDataAccessException {
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return results.iterator().next();
    }

    public static <T> T requiredUniqueResult(@Nullable Collection<T> results) throws IncorrectResultSizeDataAccessException {
        if (CollectionUtils.isEmpty(results)) {
            throw new EmptyResultDataAccessException(1);
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return results.iterator().next();
    }

    public static <T> T objectResult(@Nullable Collection<?> results, @Nullable Class<T> requiredType) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        Object result = DataAccessUtils.requiredUniqueResult(results);
        if (requiredType != null && !requiredType.isInstance(result)) {
            if (String.class == requiredType) {
                result = result.toString();
            } else if (Number.class.isAssignableFrom(requiredType) && result instanceof Number) {
                Number number = (Number)result;
                try {
                    result = NumberUtils.convertNumberToTargetClass((Number)number, requiredType);
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchDataAccessException(ex.getMessage());
                }
            } else {
                throw new TypeMismatchDataAccessException("Result object is of type [" + result.getClass().getName() + "] and could not be converted to required type [" + requiredType.getName() + "]");
            }
        }
        return (T)result;
    }

    public static int intResult(@Nullable Collection<?> results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return DataAccessUtils.objectResult(results, Number.class).intValue();
    }

    public static long longResult(@Nullable Collection<?> results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return DataAccessUtils.objectResult(results, Number.class).longValue();
    }

    public static RuntimeException translateIfNecessary(RuntimeException rawException, PersistenceExceptionTranslator pet) {
        Assert.notNull((Object)pet, (String)"PersistenceExceptionTranslator must not be null");
        DataAccessException dae = pet.translateExceptionIfPossible(rawException);
        return dae != null ? dae : rawException;
    }
}

