/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction;

import cn.taketoday.transaction.TransactionException;

public class HeuristicCompletionException
extends TransactionException {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_COMMITTED = 1;
    public static final int STATE_ROLLED_BACK = 2;
    public static final int STATE_MIXED = 3;
    private final int outcomeState;

    public static String getStateString(int state) {
        return switch (state) {
            case 1 -> "committed";
            case 2 -> "rolled back";
            case 3 -> "mixed";
            default -> "unknown";
        };
    }

    public HeuristicCompletionException(int outcomeState, Throwable cause) {
        super("Heuristic completion: outcome state is " + HeuristicCompletionException.getStateString(outcomeState), cause);
        this.outcomeState = outcomeState;
    }

    public int getOutcomeState() {
        return this.outcomeState;
    }
}

