/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction;

import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.StaticTransactionDefinition;
import cn.taketoday.transaction.annotation.Isolation;
import cn.taketoday.transaction.support.DefaultTransactionDefinition;

public interface TransactionDefinition {
    public static final int PROPAGATION_REQUIRED = 0;
    public static final int PROPAGATION_SUPPORTS = 1;
    public static final int PROPAGATION_MANDATORY = 2;
    public static final int PROPAGATION_REQUIRES_NEW = 3;
    public static final int PROPAGATION_NOT_SUPPORTED = 4;
    public static final int PROPAGATION_NEVER = 5;
    public static final int PROPAGATION_NESTED = 6;
    public static final int ISOLATION_DEFAULT = -1;
    public static final int ISOLATION_READ_UNCOMMITTED = 1;
    public static final int ISOLATION_READ_COMMITTED = 2;
    public static final int ISOLATION_REPEATABLE_READ = 4;
    public static final int ISOLATION_SERIALIZABLE = 8;
    public static final int TIMEOUT_DEFAULT = -1;

    default public int getPropagationBehavior() {
        return 0;
    }

    default public int getIsolationLevel() {
        return -1;
    }

    default public int getTimeout() {
        return -1;
    }

    default public boolean isReadOnly() {
        return false;
    }

    @Nullable
    default public String getName() {
        return null;
    }

    public static TransactionDefinition withDefaults() {
        return StaticTransactionDefinition.INSTANCE;
    }

    public static TransactionDefinition forReadOnly() {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setReadOnly(true);
        return definition;
    }

    public static TransactionDefinition forTimeout(int timeout) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setTimeout(timeout);
        return definition;
    }

    public static TransactionDefinition forIsolationLevel(int isolationLevel) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setIsolationLevel(isolationLevel);
        return definition;
    }

    public static TransactionDefinition forIsolationLevel(Isolation isolation) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setIsolationLevel(isolation.value());
        return definition;
    }
}

