/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.annotation;

import cn.taketoday.beans.factory.annotation.Autowired;
import cn.taketoday.context.annotation.ImportAware;
import cn.taketoday.context.annotation.Role;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.stereotype.Component;
import cn.taketoday.transaction.TransactionManager;
import cn.taketoday.transaction.annotation.EnableTransactionManagement;
import cn.taketoday.transaction.annotation.RestrictedTransactionalEventListenerFactory;
import cn.taketoday.transaction.annotation.TransactionManagementConfigurer;
import cn.taketoday.transaction.event.TransactionalEventListenerFactory;
import cn.taketoday.util.CollectionUtils;
import java.util.Collection;

public abstract class AbstractTransactionManagementConfiguration
implements ImportAware {
    @Nullable
    protected MergedAnnotation<EnableTransactionManagement> enableTx;
    @Nullable
    protected TransactionManager txManager;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableTx = importMetadata.getAnnotation(EnableTransactionManagement.class);
        if (!this.enableTx.isPresent()) {
            throw new IllegalArgumentException("@EnableTransactionManagement is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<TransactionManagementConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one TransactionManagementConfigurer may exist");
        }
        TransactionManagementConfigurer configurer = configurers.iterator().next();
        this.txManager = configurer.annotationDrivenTransactionManager();
    }

    @Role(value=2)
    @Component(value={"cn.taketoday.transaction.config.internalTransactionalEventListenerFactory"})
    public static TransactionalEventListenerFactory transactionalEventListenerFactory() {
        return new RestrictedTransactionalEventListenerFactory();
    }
}

