/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.annotation;

import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.annotation.TransactionAnnotationParser;
import cn.taketoday.transaction.interceptor.DefaultTransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttribute;
import jakarta.ejb.ApplicationException;
import jakarta.ejb.TransactionAttributeType;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;

public class Ejb3TransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        return AnnotationUtils.isCandidateClass(targetClass, jakarta.ejb.TransactionAttribute.class);
    }

    @Override
    @Nullable
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement element) {
        jakarta.ejb.TransactionAttribute ann = element.getAnnotation(jakarta.ejb.TransactionAttribute.class);
        if (ann != null) {
            return this.parseTransactionAnnotation(ann);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(jakarta.ejb.TransactionAttribute ann) {
        return new Ejb3TransactionAttribute(ann.value());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Ejb3TransactionAnnotationParser;
    }

    public int hashCode() {
        return Ejb3TransactionAnnotationParser.class.hashCode();
    }

    private static class Ejb3TransactionAttribute
    extends DefaultTransactionAttribute {
        public Ejb3TransactionAttribute(TransactionAttributeType type) {
            this.setPropagationBehaviorName("PROPAGATION_" + type.name());
        }

        @Override
        public boolean rollbackOn(Throwable ex) {
            ApplicationException ann = ex.getClass().getAnnotation(ApplicationException.class);
            return ann != null ? ann.rollback() : super.rollbackOn(ex);
        }
    }
}

