/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.annotation;

import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.ImportRuntimeHints;
import cn.taketoday.context.annotation.Role;
import cn.taketoday.stereotype.Component;
import cn.taketoday.transaction.annotation.AbstractTransactionManagementConfiguration;
import cn.taketoday.transaction.annotation.AnnotationTransactionAttributeSource;
import cn.taketoday.transaction.annotation.TransactionRuntimeHints;
import cn.taketoday.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import cn.taketoday.transaction.interceptor.TransactionInterceptor;
import org.aopalliance.aop.Advice;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
@ImportRuntimeHints(value={TransactionRuntimeHints.class})
public class ProxyTransactionManagementConfiguration
extends AbstractTransactionManagementConfiguration {
    @Role(value=2)
    @Component(value={"cn.taketoday.transaction.config.internalTransactionAdvisor"})
    public BeanFactoryTransactionAttributeSourceAdvisor transactionAdvisor(TransactionAttributeSource transactionAttributeSource, TransactionInterceptor transactionInterceptor) {
        BeanFactoryTransactionAttributeSourceAdvisor advisor = new BeanFactoryTransactionAttributeSourceAdvisor();
        advisor.setTransactionAttributeSource(transactionAttributeSource);
        advisor.setAdvice((Advice)transactionInterceptor);
        if (this.enableTx != null) {
            advisor.setOrder(this.enableTx.getInt("order"));
        }
        return advisor;
    }

    @Component
    @Role(value=2)
    public TransactionAttributeSource transactionAttributeSource() {
        return new AnnotationTransactionAttributeSource();
    }

    @Component
    @Role(value=2)
    public TransactionInterceptor transactionInterceptor(TransactionAttributeSource transactionAttributeSource) {
        TransactionInterceptor interceptor = new TransactionInterceptor();
        interceptor.setTransactionAttributeSource(transactionAttributeSource);
        if (this.txManager != null) {
            interceptor.setTransactionManager(this.txManager);
        }
        return interceptor;
    }
}

