/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.annotation;

import cn.taketoday.context.ApplicationListener;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.scheduling.annotation.Async;
import cn.taketoday.transaction.annotation.Propagation;
import cn.taketoday.transaction.annotation.Transactional;
import cn.taketoday.transaction.event.TransactionalEventListenerFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

public class RestrictedTransactionalEventListenerFactory
extends TransactionalEventListenerFactory {
    @Override
    public ApplicationListener<?> createApplicationListener(String beanName, Class<?> type, Method method) {
        Transactional txAnn = (Transactional)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Transactional.class);
        if (txAnn != null && txAnn.propagation() != Propagation.REQUIRES_NEW && !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Async.class)) {
            throw new IllegalStateException("@TransactionalEventListener method must not be annotated with @Transactional unless when marked as REQUIRES_NEW or declared as @Async: " + method);
        }
        return super.createApplicationListener(beanName, type, method);
    }
}

