/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.annotation;

import cn.taketoday.aot.generate.GenerationContext;
import cn.taketoday.aot.hint.MemberCategory;
import cn.taketoday.aot.hint.RuntimeHints;
import cn.taketoday.beans.factory.aot.BeanRegistrationAotContribution;
import cn.taketoday.beans.factory.aot.BeanRegistrationAotProcessor;
import cn.taketoday.beans.factory.aot.BeanRegistrationCode;
import cn.taketoday.beans.factory.support.RegisteredBean;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.transaction.annotation.Transactional;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.LinkedHashSet;

class TransactionBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final String JAKARTA_TRANSACTIONAL_CLASS_NAME = "jakarta.transaction.Transactional";

    TransactionBeanRegistrationAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        if (this.isTransactional(beanClass)) {
            return new TransactionBeanRegistrationAotContribution(beanClass);
        }
        return null;
    }

    private boolean isTransactional(Class<?> beanClass) {
        LinkedHashSet<Class> elements = new LinkedHashSet<Class>();
        elements.add(beanClass);
        ReflectionUtils.doWithMethods(beanClass, elements::add);
        for (Class interfaceClass : ClassUtils.getAllInterfacesForClass(beanClass)) {
            elements.add(interfaceClass);
            ReflectionUtils.doWithMethods((Class)interfaceClass, elements::add);
        }
        return elements.stream().anyMatch(element -> {
            MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            return mergedAnnotations.isPresent(Transactional.class) || mergedAnnotations.isPresent(JAKARTA_TRANSACTIONAL_CLASS_NAME);
        });
    }

    private static class TransactionBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final Class<?> beanClass;

        public TransactionBeanRegistrationAotContribution(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            Object[] proxyInterfaces = ClassUtils.getAllInterfacesForClass(this.beanClass);
            if (ObjectUtils.isNotEmpty((Object[])proxyInterfaces)) {
                for (Object proxyInterface : proxyInterfaces) {
                    runtimeHints.reflection().registerType((Class)proxyInterface, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
                }
            }
        }
    }
}

