/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.annotation;

import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.annotation.RepeatableContainers;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.annotation.Isolation;
import cn.taketoday.transaction.annotation.Propagation;
import cn.taketoday.transaction.annotation.TransactionAnnotationParser;
import cn.taketoday.transaction.annotation.Transactional;
import cn.taketoday.transaction.interceptor.NoRollbackRuleAttribute;
import cn.taketoday.transaction.interceptor.RollbackRuleAttribute;
import cn.taketoday.transaction.interceptor.RuleBasedTransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttribute;
import cn.taketoday.util.StringUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;

public class TransactionalAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        return AnnotationUtils.isCandidateClass(targetClass, Transactional.class);
    }

    @Override
    @Nullable
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement element) {
        MergedAnnotation attributes = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none()).get(Transactional.class);
        if (attributes.isPresent()) {
            return this.parseTransactionAnnotation((MergedAnnotation<Transactional>)attributes);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(Transactional ann) {
        return this.parseTransactionAnnotation((MergedAnnotation<Transactional>)MergedAnnotation.from((Annotation)ann));
    }

    protected TransactionAttribute parseTransactionAnnotation(MergedAnnotation<Transactional> attributes) {
        RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
        Propagation propagation = (Propagation)attributes.getEnum("propagation", Propagation.class);
        rbta.setPropagationBehavior(propagation.value());
        Isolation isolation = (Isolation)attributes.getEnum("isolation", Isolation.class);
        rbta.setIsolationLevel(isolation.value());
        rbta.setTimeout(attributes.getInt("timeout"));
        String timeoutString = attributes.getString("timeoutString");
        Assert.isTrue((StringUtils.isBlank((String)timeoutString) || rbta.getTimeout() < 0 ? 1 : 0) != 0, (String)"Specify 'timeout' or 'timeoutString', not both");
        rbta.setTimeoutString(timeoutString);
        rbta.setReadOnly(attributes.getBoolean("readOnly"));
        rbta.setQualifier(attributes.getString("value"));
        rbta.setLabels(Arrays.asList(attributes.getStringArray("label")));
        ArrayList<RollbackRuleAttribute> rollbackRules = new ArrayList<RollbackRuleAttribute>();
        for (Class clazz : attributes.getClassArray("rollbackFor")) {
            rollbackRules.add(new RollbackRuleAttribute(clazz));
        }
        for (String string : attributes.getStringArray("rollbackForClassName")) {
            rollbackRules.add(new RollbackRuleAttribute(string));
        }
        for (Class clazz : attributes.getClassArray("noRollbackFor")) {
            rollbackRules.add(new NoRollbackRuleAttribute(clazz));
        }
        for (String string : attributes.getStringArray("noRollbackForClassName")) {
            rollbackRules.add(new NoRollbackRuleAttribute(string));
        }
        rbta.setRollbackRules(rollbackRules);
        return rbta;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof TransactionalAnnotationParser;
    }

    public int hashCode() {
        return TransactionalAnnotationParser.class.hashCode();
    }
}

