/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.config;

import cn.taketoday.aop.config.AopNamespaceUtils;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.RuntimeBeanReference;
import cn.taketoday.beans.factory.parsing.BeanComponentDefinition;
import cn.taketoday.beans.factory.parsing.ComponentDefinition;
import cn.taketoday.beans.factory.parsing.CompositeComponentDefinition;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.xml.BeanDefinitionParser;
import cn.taketoday.beans.factory.xml.ParserContext;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.config.TxNamespaceHandler;
import cn.taketoday.transaction.event.TransactionalEventListenerFactory;
import cn.taketoday.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import cn.taketoday.transaction.interceptor.TransactionInterceptor;
import cn.taketoday.util.ClassUtils;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    AnnotationDrivenBeanDefinitionParser() {
    }

    @Nullable
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.registerTransactionalEventListenerFactory(parserContext);
        String mode = element.getAttribute("mode");
        if ("aspectj".equals(mode)) {
            this.registerTransactionAspect(element, parserContext);
            if (ClassUtils.isPresent((String)"jakarta.transaction.Transactional", (ClassLoader)this.getClass().getClassLoader())) {
                this.registerJtaTransactionAspect(element, parserContext);
            }
        } else {
            AopAutoProxyConfigurer.configureAutoProxyCreator(element, parserContext);
        }
        return null;
    }

    private void registerTransactionAspect(Element element, ParserContext parserContext) {
        String txAspectBeanName = "cn.taketoday.transaction.config.internalTransactionAspect";
        String txAspectClassName = "cn.taketoday.transaction.aspectj.AnnotationTransactionAspect";
        if (!parserContext.getRegistry().containsBeanDefinition(txAspectBeanName)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(txAspectClassName);
            def.setFactoryMethodName("aspectOf");
            def.setEnableDependencyInjection(false);
            AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, (BeanDefinition)def);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, txAspectBeanName));
        }
    }

    private void registerJtaTransactionAspect(Element element, ParserContext parserContext) {
        String txAspectBeanName = "cn.taketoday.transaction.config.internalJtaTransactionAspect";
        String txAspectClassName = "cn.taketoday.transaction.aspectj.JtaAnnotationTransactionAspect";
        if (!parserContext.getRegistry().containsBeanDefinition(txAspectBeanName)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(txAspectClassName);
            def.setFactoryMethodName("aspectOf");
            def.setEnableDependencyInjection(false);
            AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, (BeanDefinition)def);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, txAspectBeanName));
        }
    }

    private static void registerTransactionManager(Element element, BeanDefinition def) {
        def.getPropertyValues().add("transactionManagerBeanName", (Object)TxNamespaceHandler.getTransactionManagerName(element));
    }

    private void registerTransactionalEventListenerFactory(ParserContext parserContext) {
        RootBeanDefinition def = new RootBeanDefinition();
        def.setBeanClass(TransactionalEventListenerFactory.class);
        def.setEnableDependencyInjection(false);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, "cn.taketoday.transaction.config.internalTransactionalEventListenerFactory"));
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(Element element, ParserContext parserContext) {
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
            String txAdvisorBeanName = "cn.taketoday.transaction.config.internalTransactionAdvisor";
            if (!parserContext.getRegistry().containsBeanDefinition(txAdvisorBeanName)) {
                Object eleSource = parserContext.extractSource((Object)element);
                RootBeanDefinition sourceDef = new RootBeanDefinition("cn.taketoday.transaction.annotation.AnnotationTransactionAttributeSource");
                sourceDef.setSource(eleSource);
                sourceDef.setRole(2);
                sourceDef.setEnableDependencyInjection(false);
                String sourceName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)sourceDef);
                RootBeanDefinition interceptorDef = new RootBeanDefinition(TransactionInterceptor.class);
                interceptorDef.setSource(eleSource);
                interceptorDef.setEnableDependencyInjection(false);
                interceptorDef.setRole(2);
                AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, (BeanDefinition)interceptorDef);
                interceptorDef.getPropertyValues().add("transactionAttributeSource", (Object)new RuntimeBeanReference(sourceName));
                String interceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)interceptorDef);
                RootBeanDefinition advisorDef = new RootBeanDefinition(BeanFactoryTransactionAttributeSourceAdvisor.class);
                advisorDef.setSource(eleSource);
                advisorDef.setEnableDependencyInjection(false);
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().add("transactionAttributeSource", (Object)new RuntimeBeanReference(sourceName));
                advisorDef.getPropertyValues().add("adviceBeanName", (Object)interceptorName);
                if (element.hasAttribute("order")) {
                    advisorDef.getPropertyValues().add("order", (Object)element.getAttribute("order"));
                }
                parserContext.getRegistry().registerBeanDefinition(txAdvisorBeanName, (BeanDefinition)advisorDef);
                CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sourceDef, sourceName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptorDef, interceptorName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)advisorDef, txAdvisorBeanName));
                parserContext.registerComponent((ComponentDefinition)compositeDef);
            }
        }
    }
}

