/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.event;

import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.context.PayloadApplicationEvent;
import cn.taketoday.core.Ordered;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.event.TransactionPhase;
import cn.taketoday.transaction.event.TransactionalApplicationListenerAdapter;
import java.util.function.Consumer;

public interface TransactionalApplicationListener<E extends ApplicationEvent>
extends ApplicationListener<E>,
Ordered {
    default public int getOrder() {
        return Integer.MAX_VALUE;
    }

    default public boolean supportsAsyncExecution() {
        return false;
    }

    default public String getListenerId() {
        return "";
    }

    default public TransactionPhase getTransactionPhase() {
        return TransactionPhase.AFTER_COMMIT;
    }

    public void addCallback(SynchronizationCallback var1);

    public void processEvent(E var1);

    public static <T> TransactionalApplicationListener<PayloadApplicationEvent<T>> forPayload(Consumer<T> consumer) {
        return TransactionalApplicationListener.forPayload(TransactionPhase.AFTER_COMMIT, consumer);
    }

    public static <T> TransactionalApplicationListener<PayloadApplicationEvent<T>> forPayload(TransactionPhase phase, Consumer<T> consumer) {
        TransactionalApplicationListenerAdapter<PayloadApplicationEvent<T>> listener = new TransactionalApplicationListenerAdapter<PayloadApplicationEvent<T>>(event -> consumer.accept(event.getPayload()));
        listener.setTransactionPhase(phase);
        return listener;
    }

    public static interface SynchronizationCallback {
        default public void preProcessEvent(ApplicationEvent event) {
        }

        default public void postProcessEvent(ApplicationEvent event, @Nullable Throwable ex) {
        }
    }
}

