/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.event;

import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.ApplicationListener;
import cn.taketoday.core.Ordered;
import cn.taketoday.lang.Assert;
import cn.taketoday.transaction.event.TransactionPhase;
import cn.taketoday.transaction.event.TransactionalApplicationListener;
import cn.taketoday.transaction.event.TransactionalApplicationListenerSynchronization;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransactionalApplicationListenerAdapter<E extends ApplicationEvent>
implements TransactionalApplicationListener<E>,
Ordered {
    private String listenerId = "";
    private int order = Integer.MAX_VALUE;
    private final ApplicationListener<E> targetListener;
    private TransactionPhase transactionPhase = TransactionPhase.AFTER_COMMIT;
    private final CopyOnWriteArrayList<TransactionalApplicationListener.SynchronizationCallback> callbacks = new CopyOnWriteArrayList();

    public TransactionalApplicationListenerAdapter(ApplicationListener<E> targetListener) {
        this.targetListener = targetListener;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setTransactionPhase(TransactionPhase transactionPhase) {
        this.transactionPhase = transactionPhase;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public void setListenerId(String listenerId) {
        this.listenerId = listenerId;
    }

    @Override
    public String getListenerId() {
        return this.listenerId;
    }

    @Override
    public void addCallback(TransactionalApplicationListener.SynchronizationCallback callback) {
        Assert.notNull((Object)callback, (String)"SynchronizationCallback must not be null");
        this.callbacks.add(callback);
    }

    @Override
    public void processEvent(E event) {
        this.targetListener.onApplicationEvent(event);
    }

    public void onApplicationEvent(E event) {
        TransactionalApplicationListenerSynchronization.register(event, this, this.callbacks);
    }
}

