/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.event;

import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.context.event.ApplicationListenerMethodAdapter;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.event.TransactionPhase;
import cn.taketoday.transaction.event.TransactionalApplicationListener;
import cn.taketoday.transaction.event.TransactionalApplicationListenerSynchronization;
import cn.taketoday.transaction.event.TransactionalEventListener;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransactionalApplicationListenerMethodAdapter
extends ApplicationListenerMethodAdapter
implements TransactionalApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(TransactionalApplicationListenerMethodAdapter.class);
    private final TransactionPhase transactionPhase;
    private final boolean fallbackExecution;
    private final List<TransactionalApplicationListener.SynchronizationCallback> callbacks = new CopyOnWriteArrayList<TransactionalApplicationListener.SynchronizationCallback>();

    public TransactionalApplicationListenerMethodAdapter(String beanName, Class<?> targetClass, Method method) {
        super(beanName, targetClass, method);
        TransactionalEventListener eventAnn = (TransactionalEventListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getTargetMethod(), TransactionalEventListener.class);
        if (eventAnn == null) {
            throw new IllegalStateException("No TransactionalEventListener annotation found on method: " + method);
        }
        this.transactionPhase = eventAnn.phase();
        this.fallbackExecution = eventAnn.fallbackExecution();
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    @Override
    public void addCallback(TransactionalApplicationListener.SynchronizationCallback callback) {
        Assert.notNull((Object)callback, (String)"SynchronizationCallback must not be null");
        this.callbacks.add(callback);
    }

    @Override
    public void processEvent(ApplicationEvent event) {
        super.onApplicationEvent(event);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (TransactionalApplicationListenerSynchronization.register(event, this, this.callbacks)) {
            if (log.isDebugEnabled()) {
                log.debug("Registered transaction synchronization for {}", (Object)event);
            }
        } else if (this.fallbackExecution) {
            if (this.getTransactionPhase() == TransactionPhase.AFTER_ROLLBACK && log.isWarnEnabled()) {
                log.warn("Processing {} as a fallback execution on AFTER_ROLLBACK phase", (Object)event);
            }
            this.processEvent(event);
        } else if (log.isDebugEnabled()) {
            log.debug("No transaction is active - skipping {}", (Object)event);
        }
    }
}

