/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.interceptor.DefaultTransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.MethodClassKey;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource,
EmbeddedValueResolverAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFallbackTransactionAttributeSource.class);
    private static final TransactionAttribute NULL_TRANSACTION_ATTRIBUTE = new DefaultTransactionAttribute(){

        @Override
        public String toString() {
            return "null";
        }
    };
    @Nullable
    private transient StringValueResolver embeddedValueResolver;
    private final Map<Object, TransactionAttribute> attributeCache = new ConcurrentHashMap<Object, TransactionAttribute>(1024);

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        TransactionAttribute cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_TRANSACTION_ATTRIBUTE) {
                return null;
            }
            return cached;
        }
        TransactionAttribute txAttr = this.computeTransactionAttribute(method, targetClass);
        if (txAttr == null) {
            this.attributeCache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
        } else {
            String methodIdentification = ClassUtils.getQualifiedMethodName((Method)method, targetClass);
            if (txAttr instanceof DefaultTransactionAttribute) {
                DefaultTransactionAttribute dta = (DefaultTransactionAttribute)txAttr;
                dta.setDescriptor(methodIdentification);
                dta.resolveAttributeStrings(this.embeddedValueResolver);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Adding transactional method '{}' with attribute: {}", (Object)methodIdentification, (Object)txAttr);
            }
            this.attributeCache.put(cacheKey, txAttr);
        }
        return txAttr;
    }

    protected Object getCacheKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    @Nullable
    protected TransactionAttribute computeTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        TransactionAttribute txAttr = this.findTransactionAttribute(specificMethod);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = this.findTransactionAttribute(specificMethod.getDeclaringClass());
        if (txAttr != null && ClassUtils.isUserLevelMethod((Method)method)) {
            return txAttr;
        }
        if (specificMethod != method) {
            txAttr = this.findTransactionAttribute(method);
            if (txAttr != null) {
                return txAttr;
            }
            txAttr = this.findTransactionAttribute(method.getDeclaringClass());
            if (txAttr != null && ClassUtils.isUserLevelMethod((Method)method)) {
                return txAttr;
            }
        }
        return null;
    }

    @Nullable
    protected abstract TransactionAttribute findTransactionAttribute(Class<?> var1);

    @Nullable
    protected abstract TransactionAttribute findTransactionAttribute(Method var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

