/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.interceptor.TransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import java.io.Serializable;
import java.lang.reflect.Method;

public class CompositeTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    private final TransactionAttributeSource[] transactionAttributeSources;

    public CompositeTransactionAttributeSource(TransactionAttributeSource ... transactionAttributeSources) {
        Assert.notNull((Object)transactionAttributeSources, (String)"TransactionAttributeSource array must not be null");
        this.transactionAttributeSources = transactionAttributeSources;
    }

    public final TransactionAttributeSource[] getTransactionAttributeSources() {
        return this.transactionAttributeSources;
    }

    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        for (TransactionAttributeSource source : this.transactionAttributeSources) {
            if (!source.isCandidateClass(targetClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        for (TransactionAttributeSource source : this.transactionAttributeSources) {
            TransactionAttribute attr = source.getTransactionAttribute(method, targetClass);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }
}

