/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.context.expression.EmbeddedValueResolverAware;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.interceptor.DefaultTransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MethodMapTransactionAttributeSource
implements TransactionAttributeSource,
EmbeddedValueResolverAware,
BeanClassLoaderAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MethodMapTransactionAttributeSource.class);
    @Nullable
    private Map<String, TransactionAttribute> methodMap;
    @Nullable
    private StringValueResolver embeddedValueResolver;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean eagerlyInitialized = false;
    private boolean initialized = false;
    private final HashMap<Method, TransactionAttribute> transactionAttributeMap = new HashMap();
    private final HashMap<Method, String> methodNameMap = new HashMap();

    public void setMethodMap(Map<String, TransactionAttribute> methodMap) {
        this.methodMap = methodMap;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void afterPropertiesSet() {
        this.initMethodMap(this.methodMap);
        this.eagerlyInitialized = true;
        this.initialized = true;
    }

    protected void initMethodMap(@Nullable Map<String, TransactionAttribute> methodMap) {
        if (methodMap != null) {
            for (Map.Entry<String, TransactionAttribute> entry : methodMap.entrySet()) {
                this.addTransactionalMethod(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addTransactionalMethod(String name, TransactionAttribute attr) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String className = name.substring(0, lastDotIndex);
        String methodName = name.substring(lastDotIndex + 1);
        Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)this.beanClassLoader);
        this.addTransactionalMethod(clazz, methodName, attr);
    }

    public void addTransactionalMethod(Class<?> clazz, String mappedName, TransactionAttribute attr) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.notNull((Object)mappedName, (String)"Mapped name must not be null");
        String name = clazz.getName() + "." + mappedName;
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!this.isMatch(method.getName(), mappedName)) continue;
            matchingMethods.add(method);
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Could not find method '" + mappedName + "' on class [" + clazz.getName() + "]");
        }
        for (Method method : matchingMethods) {
            String regMethodName = this.methodNameMap.get(method);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (log.isDebugEnabled() && regMethodName != null) {
                    log.debug("Replacing attribute for transactional method [{}]: current name '{}' is more specific than '{}'", new Object[]{method, name, regMethodName});
                }
                this.methodNameMap.put(method, name);
                this.addTransactionalMethod(method, attr);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Keeping attribute for transactional method [{}]: current name '{}' is not more specific than '{}'", new Object[]{method, name, regMethodName});
        }
    }

    public void addTransactionalMethod(Method method, TransactionAttribute attr) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)attr, (String)"TransactionAttribute must not be null");
        if (log.isDebugEnabled()) {
            log.debug("Adding transactional method [{}] with attribute [{}]", (Object)method, (Object)attr);
        }
        if (this.embeddedValueResolver != null && attr instanceof DefaultTransactionAttribute) {
            DefaultTransactionAttribute dta = (DefaultTransactionAttribute)attr;
            dta.resolveAttributeStrings(this.embeddedValueResolver);
        }
        this.transactionAttributeMap.put(method, attr);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return StringUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        if (this.eagerlyInitialized) {
            return this.transactionAttributeMap.get(method);
        }
        HashMap<Method, TransactionAttribute> hashMap = this.transactionAttributeMap;
        synchronized (hashMap) {
            if (!this.initialized) {
                this.initMethodMap(this.methodMap);
                this.initialized = true;
            }
            return this.transactionAttributeMap.get(method);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodMapTransactionAttributeSource)) {
            return false;
        }
        MethodMapTransactionAttributeSource otherTas = (MethodMapTransactionAttributeSource)other;
        return ObjectUtils.nullSafeEquals(this.methodMap, otherTas.methodMap);
    }

    public int hashCode() {
        return MethodMapTransactionAttributeSource.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.methodMap;
    }
}

