/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.beans.factory.annotation.BeanFactoryAnnotationUtils;
import cn.taketoday.core.NamedThreadLocal;
import cn.taketoday.core.ReactiveAdapter;
import cn.taketoday.core.ReactiveAdapterRegistry;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.transaction.NoTransactionException;
import cn.taketoday.transaction.PlatformTransactionManager;
import cn.taketoday.transaction.ReactiveTransaction;
import cn.taketoday.transaction.ReactiveTransactionManager;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.TransactionManager;
import cn.taketoday.transaction.TransactionStatus;
import cn.taketoday.transaction.TransactionSystemException;
import cn.taketoday.transaction.interceptor.CompositeTransactionAttributeSource;
import cn.taketoday.transaction.interceptor.DefaultTransactionAttribute;
import cn.taketoday.transaction.interceptor.DelegatingTransactionAttribute;
import cn.taketoday.transaction.interceptor.NameMatchTransactionAttributeSource;
import cn.taketoday.transaction.interceptor.TransactionAttribute;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import cn.taketoday.transaction.reactive.TransactionContextManager;
import cn.taketoday.transaction.support.CallbackPreferringPlatformTransactionManager;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class TransactionAspectSupport
implements BeanFactoryAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TransactionAspectSupport.class);
    private static final Object DEFAULT_TRANSACTION_MANAGER_KEY = new Object();
    @Nullable
    private static final ReactiveAdapterRegistry reactiveAdapterRegistry = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)TransactionAspectSupport.class.getClassLoader()) ? ReactiveAdapterRegistry.getSharedInstance() : null;
    private static final ThreadLocal<TransactionInfo> transactionInfoHolder = new NamedThreadLocal("Current aspect-driven transaction");
    @Nullable
    private String transactionManagerBeanName;
    @Nullable
    private TransactionManager transactionManager;
    @Nullable
    private TransactionAttributeSource transactionAttributeSource;
    @Nullable
    private BeanFactory beanFactory;
    private final ConcurrentReferenceHashMap<Object, TransactionManager> transactionManagerCache = new ConcurrentReferenceHashMap(4);
    private final ConcurrentReferenceHashMap<Method, ReactiveTransactionSupport> transactionSupportCache = new ConcurrentReferenceHashMap(1024);

    @Nullable
    protected static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        return transactionInfoHolder.get();
    }

    public static TransactionStatus currentTransactionStatus() throws NoTransactionException {
        TransactionInfo info = TransactionAspectSupport.currentTransactionInfo();
        if (info == null || info.transactionStatus == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info.transactionStatus;
    }

    public void setTransactionManagerBeanName(@Nullable String transactionManagerBeanName) {
        this.transactionManagerBeanName = transactionManagerBeanName;
    }

    @Nullable
    protected final String getTransactionManagerBeanName() {
        return this.transactionManagerBeanName;
    }

    public void setTransactionManager(@Nullable TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Nullable
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(transactionAttributes);
        this.transactionAttributeSource = tas;
    }

    public void setTransactionAttributeSources(TransactionAttributeSource ... transactionAttributeSources) {
        this.transactionAttributeSource = new CompositeTransactionAttributeSource(transactionAttributeSources);
    }

    public void setTransactionAttributeSource(@Nullable TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    @Nullable
    public TransactionAttributeSource getTransactionAttributeSource() {
        return this.transactionAttributeSource;
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Nullable
    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getTransactionManager() == null && this.beanFactory == null) {
            throw new IllegalStateException("Set the 'transactionManager' property or make sure to run within a BeanFactory containing a TransactionManager bean!");
        }
        if (this.getTransactionAttributeSource() == null) {
            throw new IllegalStateException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, then don't use a transaction aspect.");
        }
    }

    @Nullable
    protected Object invokeWithinTransaction(Method method, @Nullable Class<?> targetClass, InvocationCallback invocation) throws Throwable {
        Object result;
        TransactionAttributeSource tas = this.getTransactionAttributeSource();
        TransactionAttribute txAttr = tas != null ? tas.getTransactionAttribute(method, targetClass) : null;
        TransactionManager tm = this.determineTransactionManager(txAttr);
        if (reactiveAdapterRegistry != null && tm instanceof ReactiveTransactionManager) {
            ReactiveTransactionSupport txSupport = (ReactiveTransactionSupport)this.transactionSupportCache.computeIfAbsent((Object)method, key -> {
                Class<?> reactiveType = key.getReturnType();
                ReactiveAdapter adapter = reactiveAdapterRegistry.getAdapter(reactiveType);
                if (adapter == null) {
                    throw new IllegalStateException("Cannot apply reactive transaction to non-reactive return type: " + key.getReturnType());
                }
                return new ReactiveTransactionSupport(adapter);
            });
            return txSupport.invokeWithinTransaction(method, targetClass, invocation, txAttr, (ReactiveTransactionManager)tm);
        }
        PlatformTransactionManager ptm = this.asPlatformTransactionManager(tm);
        String joinpointIdentification = this.methodIdentification(method, targetClass, txAttr);
        if (txAttr == null || !(ptm instanceof CallbackPreferringPlatformTransactionManager)) {
            Future future;
            Object retVal;
            TransactionInfo txInfo = this.createTransactionIfNecessary(ptm, txAttr, joinpointIdentification);
            try {
                retVal = invocation.proceedWithInvocation();
            }
            catch (Throwable ex) {
                this.completeTransactionAfterThrowing(txInfo, ex);
                throw ex;
            }
            finally {
                this.cleanupTransactionInfo(txInfo);
            }
            if (retVal != null && txAttr != null && txInfo.transactionStatus != null && retVal instanceof Future && (future = (Future)retVal).isDone()) {
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    if (txAttr.rollbackOn(ex.getCause())) {
                        txInfo.transactionStatus.setRollbackOnly();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.commitTransactionAfterReturning(txInfo);
            return retVal;
        }
        ThrowableHolder throwableHolder = new ThrowableHolder();
        try {
            result = ((CallbackPreferringPlatformTransactionManager)ptm).execute(txAttr, status -> {
                TransactionInfo txInfo = this.prepareTransactionInfo(ptm, txAttr, joinpointIdentification, status);
                try {
                    Object object = invocation.proceedWithInvocation();
                    return object;
                }
                catch (Throwable ex) {
                    if (txAttr.rollbackOn(ex)) {
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        throw new ThrowableHolderException(ex);
                    }
                    throwableHolder.throwable = ex;
                    Object var9_10 = null;
                    return var9_10;
                }
                finally {
                    this.cleanupTransactionInfo(txInfo);
                }
            });
        }
        catch (ThrowableHolderException ex) {
            throw ex.getCause();
        }
        catch (TransactionSystemException ex2) {
            if (throwableHolder.throwable != null) {
                log.error("Application exception overridden by commit exception", throwableHolder.throwable);
                ex2.initApplicationException(throwableHolder.throwable);
            }
            throw ex2;
        }
        catch (Throwable ex2) {
            if (throwableHolder.throwable != null) {
                log.error("Application exception overridden by commit exception", throwableHolder.throwable);
            }
            throw ex2;
        }
        if (throwableHolder.throwable != null) {
            throw throwableHolder.throwable;
        }
        return result;
    }

    protected void clearTransactionManagerCache() {
        this.transactionManagerCache.clear();
        this.beanFactory = null;
    }

    @Nullable
    protected TransactionManager determineTransactionManager(@Nullable TransactionAttribute txAttr) {
        if (txAttr == null || this.beanFactory == null) {
            return this.getTransactionManager();
        }
        String qualifier = txAttr.getQualifier();
        if (StringUtils.hasText((String)qualifier)) {
            return this.determineQualifiedTransactionManager(this.beanFactory, qualifier);
        }
        if (StringUtils.hasText((String)this.transactionManagerBeanName)) {
            return this.determineQualifiedTransactionManager(this.beanFactory, this.transactionManagerBeanName);
        }
        TransactionManager defaultTransactionManager = this.getTransactionManager();
        if (defaultTransactionManager == null && (defaultTransactionManager = (TransactionManager)this.transactionManagerCache.get(DEFAULT_TRANSACTION_MANAGER_KEY)) == null) {
            defaultTransactionManager = (TransactionManager)this.beanFactory.getBean(TransactionManager.class);
            this.transactionManagerCache.putIfAbsent(DEFAULT_TRANSACTION_MANAGER_KEY, (Object)defaultTransactionManager);
        }
        return defaultTransactionManager;
    }

    private TransactionManager determineQualifiedTransactionManager(BeanFactory beanFactory, String qualifier) {
        TransactionManager txManager = (TransactionManager)this.transactionManagerCache.get((Object)qualifier);
        if (txManager == null) {
            txManager = (TransactionManager)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)beanFactory, PlatformTransactionManager.class, (String)qualifier);
            this.transactionManagerCache.putIfAbsent((Object)qualifier, (Object)txManager);
        }
        return txManager;
    }

    @Nullable
    private PlatformTransactionManager asPlatformTransactionManager(@Nullable Object transactionManager) {
        if (transactionManager == null || transactionManager instanceof PlatformTransactionManager) {
            return (PlatformTransactionManager)transactionManager;
        }
        throw new IllegalStateException("Specified transaction manager is not a PlatformTransactionManager: " + transactionManager);
    }

    private String methodIdentification(Method method, @Nullable Class<?> targetClass, @Nullable TransactionAttribute txAttr) {
        String methodIdentification = this.methodIdentification(method, targetClass);
        if (methodIdentification == null) {
            if (txAttr instanceof DefaultTransactionAttribute) {
                methodIdentification = ((DefaultTransactionAttribute)txAttr).getDescriptor();
            }
            if (methodIdentification == null) {
                methodIdentification = ClassUtils.getQualifiedMethodName((Method)method, targetClass);
            }
        }
        return methodIdentification;
    }

    @Nullable
    protected String methodIdentification(Method method, @Nullable Class<?> targetClass) {
        return null;
    }

    protected TransactionInfo createTransactionIfNecessary(@Nullable PlatformTransactionManager tm, @Nullable TransactionAttribute txAttr, String joinpointIdentification) {
        if (txAttr != null && txAttr.getName() == null) {
            txAttr = new JoinPointTransactionAttribute(txAttr, joinpointIdentification);
        }
        TransactionStatus status = null;
        if (txAttr != null) {
            if (tm != null) {
                status = tm.getTransaction(txAttr);
            } else if (log.isDebugEnabled()) {
                log.debug("Skipping transactional joinpoint [{}] because no transaction manager has been configured", (Object)joinpointIdentification);
            }
        }
        return this.prepareTransactionInfo(tm, txAttr, joinpointIdentification, status);
    }

    protected TransactionInfo prepareTransactionInfo(@Nullable PlatformTransactionManager tm, @Nullable TransactionAttribute txAttr, String joinpointIdentification, @Nullable TransactionStatus status) {
        TransactionInfo txInfo = new TransactionInfo(tm, txAttr, joinpointIdentification);
        if (txAttr != null) {
            if (log.isDebugEnabled()) {
                log.trace("Getting transaction for [{}]", (Object)txInfo.joinpointIdentification);
            }
            txInfo.newTransactionStatus(status);
        } else if (log.isDebugEnabled()) {
            log.trace("No need to create transaction for [{}]: This method is not transactional.", (Object)joinpointIdentification);
        }
        txInfo.bindToThread();
        return txInfo;
    }

    protected void commitTransactionAfterReturning(@Nullable TransactionInfo txInfo) {
        if (txInfo != null && txInfo.hasTransaction()) {
            if (log.isDebugEnabled()) {
                log.trace("Completing transaction for [{}]", (Object)txInfo.joinpointIdentification);
            }
            txInfo.commit();
        }
    }

    protected void completeTransactionAfterThrowing(@Nullable TransactionInfo txInfo, Throwable ex) {
        if (txInfo != null && txInfo.hasTransaction()) {
            if (log.isDebugEnabled()) {
                log.trace("Completing transaction for [{}] after exception: {}", (Object)txInfo.joinpointIdentification, (Object)ex);
            }
            if (txInfo.transactionAttribute != null && txInfo.transactionAttribute.rollbackOn(ex)) {
                try {
                    txInfo.rollback();
                }
                catch (TransactionSystemException ex2) {
                    log.error("Application exception overridden by rollback exception", ex);
                    ex2.initApplicationException(ex);
                    throw ex2;
                }
                catch (Error | RuntimeException ex2) {
                    log.error("Application exception overridden by rollback exception", ex);
                    throw ex2;
                }
            }
            try {
                txInfo.commit();
            }
            catch (TransactionSystemException ex2) {
                log.error("Application exception overridden by commit exception", ex);
                ex2.initApplicationException(ex);
                throw ex2;
            }
            catch (Error | RuntimeException ex2) {
                log.error("Application exception overridden by commit exception", ex);
                throw ex2;
            }
        }
    }

    protected void cleanupTransactionInfo(@Nullable TransactionInfo txInfo) {
        if (txInfo != null) {
            txInfo.restoreThreadLocalStatus();
        }
    }

    protected static final class TransactionInfo {
        @Nullable
        public final PlatformTransactionManager transactionManager;
        @Nullable
        public final TransactionAttribute transactionAttribute;
        public final String joinpointIdentification;
        @Nullable
        public TransactionStatus transactionStatus;
        @Nullable
        public TransactionInfo oldTransactionInfo;

        public TransactionInfo(@Nullable PlatformTransactionManager transactionManager, @Nullable TransactionAttribute transactionAttribute, String joinpointIdentification) {
            this.transactionManager = transactionManager;
            this.transactionAttribute = transactionAttribute;
            this.joinpointIdentification = joinpointIdentification;
        }

        @Nullable
        public TransactionAttribute getTransactionAttribute() {
            return this.transactionAttribute;
        }

        public void newTransactionStatus(@Nullable TransactionStatus status) {
            this.transactionStatus = status;
        }

        public void commit() throws TransactionException {
            PlatformTransactionManager transactionManager = this.transactionManager;
            Assert.state((transactionManager != null ? 1 : 0) != 0, (String)"No PlatformTransactionManager set");
            transactionManager.commit(this.transactionStatus);
        }

        public void rollback() throws TransactionException {
            PlatformTransactionManager transactionManager = this.transactionManager;
            Assert.state((transactionManager != null ? 1 : 0) != 0, (String)"No PlatformTransactionManager set");
            transactionManager.rollback(this.transactionStatus);
        }

        public boolean hasTransaction() {
            return this.transactionStatus != null;
        }

        private void bindToThread() {
            this.oldTransactionInfo = transactionInfoHolder.get();
            transactionInfoHolder.set(this);
        }

        private void restoreThreadLocalStatus() {
            transactionInfoHolder.set(this.oldTransactionInfo);
        }

        public String toString() {
            return this.transactionAttribute != null ? this.transactionAttribute.toString() : "No transaction";
        }
    }

    private class ReactiveTransactionSupport {
        private final ReactiveAdapter adapter;

        public ReactiveTransactionSupport(ReactiveAdapter adapter) {
            this.adapter = adapter;
        }

        public Object invokeWithinTransaction(Method method, @Nullable Class<?> targetClass, InvocationCallback invocation, @Nullable TransactionAttribute txAttr, ReactiveTransactionManager rtm) {
            String joinpointIdentification = TransactionAspectSupport.this.methodIdentification(method, targetClass, txAttr);
            if (Mono.class.isAssignableFrom(method.getReturnType())) {
                return TransactionContextManager.currentContext().flatMap(context -> Mono.usingWhen(this.createTransactionIfNecessary(rtm, txAttr, joinpointIdentification), tx -> {
                    try {
                        return (Mono)invocation.proceedWithInvocation();
                    }
                    catch (Throwable ex) {
                        return Mono.error((Throwable)ex);
                    }
                }, this::commitTransactionAfterReturning, this::completeTransactionAfterThrowing, this::rollbackTransactionOnCancel).onErrorMap(this::unwrapIfResourceCleanupFailure)).contextWrite(TransactionContextManager.getOrCreateContext()).contextWrite(TransactionContextManager.getOrCreateContextHolder());
            }
            return this.adapter.fromPublisher((Publisher)TransactionContextManager.currentContext().flatMapMany(context -> Flux.usingWhen(this.createTransactionIfNecessary(rtm, txAttr, joinpointIdentification), tx -> {
                try {
                    return this.adapter.toPublisher(invocation.proceedWithInvocation());
                }
                catch (Throwable ex) {
                    return Mono.error((Throwable)ex);
                }
            }, this::commitTransactionAfterReturning, this::completeTransactionAfterThrowing, this::rollbackTransactionOnCancel).onErrorMap(this::unwrapIfResourceCleanupFailure)).contextWrite(TransactionContextManager.getOrCreateContext()).contextWrite(TransactionContextManager.getOrCreateContextHolder()));
        }

        private Mono<ReactiveTransactionInfo> createTransactionIfNecessary(ReactiveTransactionManager tm, @Nullable TransactionAttribute txAttr, String joinpointIdentification) {
            TransactionAttribute attrToUse;
            if (txAttr != null && txAttr.getName() == null) {
                txAttr = new JoinPointTransactionAttribute(txAttr, joinpointIdentification);
            }
            Mono<ReactiveTransaction> tx = (attrToUse = txAttr) != null ? tm.getReactiveTransaction(attrToUse) : Mono.empty();
            return tx.map(it -> this.prepareTransactionInfo(tm, attrToUse, joinpointIdentification, (ReactiveTransaction)it)).switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.prepareTransactionInfo(tm, attrToUse, joinpointIdentification, null))));
        }

        private ReactiveTransactionInfo prepareTransactionInfo(@Nullable ReactiveTransactionManager tm, @Nullable TransactionAttribute txAttr, String joinpointIdentification, @Nullable ReactiveTransaction transaction) {
            ReactiveTransactionInfo txInfo = new ReactiveTransactionInfo(tm, txAttr, joinpointIdentification);
            if (txAttr != null) {
                if (log.isDebugEnabled()) {
                    log.trace("Getting transaction for [{}]", (Object)txInfo.joinpointIdentification);
                }
                txInfo.newReactiveTransaction(transaction);
            } else if (log.isDebugEnabled()) {
                log.trace("Don't need to create transaction for [{}]: This method isn't transactional.", (Object)joinpointIdentification);
            }
            return txInfo;
        }

        private Mono<Void> commitTransactionAfterReturning(@Nullable ReactiveTransactionInfo txInfo) {
            if (txInfo != null && txInfo.reactiveTransaction != null) {
                if (log.isDebugEnabled()) {
                    log.trace("Completing transaction for [{}]", (Object)txInfo.joinpointIdentification);
                }
                return txInfo.commit();
            }
            return Mono.empty();
        }

        private Mono<Void> rollbackTransactionOnCancel(@Nullable ReactiveTransactionInfo txInfo) {
            if (txInfo != null && txInfo.reactiveTransaction != null) {
                if (log.isDebugEnabled()) {
                    log.trace("Rolling back transaction for [{}] after cancellation", (Object)txInfo.joinpointIdentification);
                }
                return txInfo.rollback();
            }
            return Mono.empty();
        }

        private Mono<Void> completeTransactionAfterThrowing(@Nullable ReactiveTransactionInfo txInfo, Throwable ex) {
            if (txInfo != null && txInfo.reactiveTransaction != null) {
                if (log.isDebugEnabled()) {
                    log.trace("Completing transaction for [{}] after exception: {}", (Object)txInfo.joinpointIdentification, (Object)ex.toString());
                }
                if (txInfo.transactionAttribute != null && txInfo.transactionAttribute.rollbackOn(ex)) {
                    return txInfo.rollback().onErrorMap(ex2 -> {
                        log.error("Application exception overridden by rollback exception", ex);
                        if (ex2 instanceof TransactionSystemException) {
                            ((TransactionSystemException)((Object)((Object)ex2))).initApplicationException(ex);
                        } else {
                            ex2.addSuppressed(ex);
                        }
                        return ex2;
                    });
                }
                return txInfo.commit().onErrorMap(ex2 -> {
                    log.error("Application exception overridden by commit exception", ex);
                    if (ex2 instanceof TransactionSystemException) {
                        ((TransactionSystemException)((Object)((Object)ex2))).initApplicationException(ex);
                    } else {
                        ex2.addSuppressed(ex);
                    }
                    return ex2;
                });
            }
            return Mono.empty();
        }

        private Throwable unwrapIfResourceCleanupFailure(Throwable ex) {
            String msg;
            if (ex instanceof RuntimeException && ex.getCause() != null && (msg = ex.getMessage()) != null && msg.startsWith("Async resource cleanup failed")) {
                return ex.getCause();
            }
            return ex;
        }
    }

    @FunctionalInterface
    public static interface InvocationCallback {
        @Nullable
        public Object proceedWithInvocation() throws Throwable;
    }

    private static class ThrowableHolder {
        @Nullable
        public Throwable throwable;

        private ThrowableHolder() {
        }
    }

    private static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable throwable) {
            super(throwable);
        }

        @Override
        public String toString() {
            return this.getCause().toString();
        }
    }

    static class JoinPointTransactionAttribute
    extends DelegatingTransactionAttribute {
        private static final long serialVersionUID = 1L;
        private final String joinpointIdentification;

        public JoinPointTransactionAttribute(TransactionAttribute targetAttribute, String joinpointIdentification) {
            super(targetAttribute);
            this.joinpointIdentification = joinpointIdentification;
        }

        @Override
        public String getName() {
            return this.joinpointIdentification;
        }
    }

    private static final class ReactiveTransactionInfo {
        @Nullable
        public final ReactiveTransactionManager transactionManager;
        @Nullable
        public final TransactionAttribute transactionAttribute;
        public final String joinpointIdentification;
        @Nullable
        public ReactiveTransaction reactiveTransaction;

        public ReactiveTransactionInfo(@Nullable ReactiveTransactionManager transactionManager, @Nullable TransactionAttribute transactionAttribute, String joinpointIdentification) {
            this.transactionManager = transactionManager;
            this.transactionAttribute = transactionAttribute;
            this.joinpointIdentification = joinpointIdentification;
        }

        public Mono<Void> commit() {
            Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"No ReactiveTransactionManager set");
            return this.transactionManager.commit(this.reactiveTransaction);
        }

        public Mono<Void> rollback() {
            Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"No ReactiveTransactionManager set");
            return this.transactionManager.rollback(this.reactiveTransaction);
        }

        public void newReactiveTransaction(@Nullable ReactiveTransaction transaction) {
            this.reactiveTransaction = transaction;
        }

        public String toString() {
            return this.transactionAttribute != null ? this.transactionAttribute.toString() : "No transaction";
        }
    }

    protected static interface CoroutinesInvocationCallback
    extends InvocationCallback {
        public Object getTarget();

        public Object[] getArguments();

        default public Object getContinuation() {
            Object[] args = this.getArguments();
            return args[args.length - 1];
        }
    }
}

