/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.interceptor.NoRollbackRuleAttribute;
import cn.taketoday.transaction.interceptor.RollbackRuleAttribute;
import cn.taketoday.transaction.interceptor.RuleBasedTransactionAttribute;
import cn.taketoday.util.StringUtils;
import java.util.Collection;

public interface TransactionAttribute
extends TransactionDefinition {
    @Nullable
    public String getQualifier();

    public Collection<String> getLabels();

    public boolean rollbackOn(Throwable var1);

    public static TransactionAttribute parse(String text) throws IllegalArgumentException {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)text);
        RuleBasedTransactionAttribute attr = new RuleBasedTransactionAttribute();
        for (String token : tokens) {
            String trimmedToken = token.strip();
            if (StringUtils.containsWhitespace((String)trimmedToken)) {
                throw new IllegalArgumentException("Transaction attribute token contains illegal whitespace: [" + trimmedToken + "]");
            }
            if (trimmedToken.startsWith("PROPAGATION_")) {
                attr.setPropagationBehaviorName(trimmedToken);
                continue;
            }
            if (trimmedToken.startsWith("ISOLATION_")) {
                attr.setIsolationLevelName(trimmedToken);
                continue;
            }
            if (trimmedToken.startsWith("timeout_")) {
                String value = trimmedToken.substring("timeout_".length());
                attr.setTimeoutString(value);
                continue;
            }
            if (trimmedToken.equals("readOnly")) {
                attr.setReadOnly(true);
                continue;
            }
            if (trimmedToken.startsWith("+")) {
                attr.getRollbackRules().add(new NoRollbackRuleAttribute(trimmedToken.substring(1)));
                continue;
            }
            if (trimmedToken.startsWith("-")) {
                attr.getRollbackRules().add(new RollbackRuleAttribute(trimmedToken.substring(1)));
                continue;
            }
            throw new IllegalArgumentException("Invalid transaction attribute token: [" + trimmedToken + "]");
        }
        attr.resolveAttributeStrings(null);
        return attr;
    }
}

