/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.transaction.interceptor;

import cn.taketoday.aop.ClassFilter;
import cn.taketoday.aop.support.StaticMethodMatcherPointcut;
import cn.taketoday.dao.support.PersistenceExceptionTranslator;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.TransactionManager;
import cn.taketoday.transaction.interceptor.TransactionAttributeSource;
import cn.taketoday.transaction.interceptor.TransactionalProxy;
import cn.taketoday.util.ObjectUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;

class TransactionAttributeSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private TransactionAttributeSource transactionAttributeSource;

    public TransactionAttributeSourcePointcut() {
        this.setClassFilter(new TransactionAttributeSourceClassFilter());
    }

    public void setTransactionAttributeSource(@Nullable TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return this.transactionAttributeSource == null || this.transactionAttributeSource.getTransactionAttribute(method, targetClass) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof TransactionAttributeSourcePointcut)) return false;
        TransactionAttributeSourcePointcut otherPc = (TransactionAttributeSourcePointcut)other;
        if (!Objects.equals(this.transactionAttributeSource, otherPc.transactionAttributeSource)) return false;
        return true;
    }

    public int hashCode() {
        return TransactionAttributeSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transactionAttributeSource;
    }

    private class TransactionAttributeSourceClassFilter
    implements ClassFilter {
        private TransactionAttributeSourceClassFilter() {
        }

        public boolean matches(Class<?> clazz) {
            if (TransactionalProxy.class.isAssignableFrom(clazz) || TransactionManager.class.isAssignableFrom(clazz) || PersistenceExceptionTranslator.class.isAssignableFrom(clazz)) {
                return false;
            }
            return TransactionAttributeSourcePointcut.this.transactionAttributeSource == null || TransactionAttributeSourcePointcut.this.transactionAttributeSource.isCandidateClass(clazz);
        }

        @Nullable
        private TransactionAttributeSource getTransactionAttributeSource() {
            return TransactionAttributeSourcePointcut.this.transactionAttributeSource;
        }

        public boolean equals(@Nullable Object other) {
            TransactionAttributeSourceClassFilter that;
            return this == other || other instanceof TransactionAttributeSourceClassFilter && ObjectUtils.nullSafeEquals((Object)TransactionAttributeSourcePointcut.this.transactionAttributeSource, (Object)(that = (TransactionAttributeSourceClassFilter)other).getTransactionAttributeSource());
        }

        public int hashCode() {
            return TransactionAttributeSourceClassFilter.class.hashCode();
        }

        public String toString() {
            return TransactionAttributeSourceClassFilter.class.getName() + ": " + TransactionAttributeSourcePointcut.this.transactionAttributeSource;
        }
    }
}

